/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import baubles.api.BaublesApi;
import de.maxhenkel.gravestone.BlockGraveStone;
import de.maxhenkel.gravestone.BlockNotFoundException;
import de.maxhenkel.gravestone.GraveInventoryHelper;
import de.maxhenkel.gravestone.MBlocks;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.TileEntityGraveStone;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;

public class DeathPosition {
    private EntityPlayer player;
    private World world;
    private boolean keepInventory;
    private BlockPos deathPosition;
    private static ArrayList<Block> replaceableBlocks;
    public static final String[] DEFAULT_BLOCKS;

    public DeathPosition(EntityPlayer player) {
        this.player = player;
        this.world = player.field_70170_p;
        this.deathPosition = player.func_180425_c();
        this.keepInventory = player.field_70170_p.func_72912_H().func_82574_x().func_82766_b("keepInventory");
        if (replaceableBlocks == null) {
            try {
                Configuration c = Main.getInstance().getConfig();
                c.load();
                String[] blocks = c.get("Gravestone", "Replaceable blocks", DEFAULT_BLOCKS).getStringList();
                replaceableBlocks = DeathPosition.getBlocks(blocks);
                if (blocks == null) {
                    replaceableBlocks = DeathPosition.getBlocks(DEFAULT_BLOCKS);
                }
                c.save();
            }
            catch (Exception e) {
                replaceableBlocks = new ArrayList();
            }
        }
    }

    public boolean placeGraveStone() {
        BlockPos gravePos;
        if (this.keepInventory) {
            return true;
        }
        try {
            gravePos = this.getGraveStoneLocation();
        }
        catch (BlockNotFoundException e) {
            return false;
        }
        try {
            this.world.func_175656_a(gravePos, MBlocks.gravestone.func_176223_P().func_177226_a((IProperty)BlockGraveStone.FACING, (Comparable)this.player.func_174811_aO().func_176734_d()));
        }
        catch (Exception e) {
            return false;
        }
        TileEntity tileentity = this.world.func_175625_s(gravePos);
        if (tileentity == null || !(tileentity instanceof TileEntityGraveStone)) {
            return false;
        }
        try {
            TileEntityGraveStone graveTileEntity = (TileEntityGraveStone)tileentity;
            graveTileEntity.setPlayerName(this.player.getDisplayNameString());
            graveTileEntity.setDeathTime();
            GraveInventoryHelper invHelper = new GraveInventoryHelper(graveTileEntity);
            this.addItems(invHelper, (IInventory)this.player.field_71071_by);
            IInventory inv = null;
            try {
                if (Loader.isModLoaded((String)"Baubles")) {
                    inv = BaublesApi.getBaubles((EntityPlayer)this.player);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.addItems(invHelper, inv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void addItems(GraveInventoryHelper invHelper, IInventory inv) {
        try {
            if (inv == null) {
                return;
            }
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                boolean added;
                ItemStack items = inv.func_70301_a(i);
                boolean shouldAdd = true;
                try {
                    shouldAdd = DeathPosition.shouldAdd(items);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!shouldAdd || !(added = invHelper.addItem(items))) continue;
                inv.func_70299_a(i, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean shouldAdd(ItemStack item) {
        if (item == null) {
            return false;
        }
        NBTTagList list = item.func_77986_q();
        for (int j = 0; j < list.func_74745_c(); ++j) {
            NBTTagCompound tag = list.func_150305_b(j);
            int id = tag.func_74762_e("id");
            Enchantment enchantment = (Enchantment)Enchantment.field_185264_b.func_148754_a(id);
            if (!enchantment.func_77320_a().equals("enchantment.soulBound")) continue;
            return false;
        }
        return true;
    }

    public BlockPos getGraveStoneLocation() throws BlockNotFoundException {
        BlockPos location = new BlockPos(this.deathPosition.func_177958_n(), this.deathPosition.func_177956_o(), this.deathPosition.func_177952_p());
        if (location.func_177956_o() < 0) {
            location = new BlockPos(location.func_177958_n(), 0, location.func_177952_p());
        }
        for (int i = 0; i < this.player.field_70170_p.func_72800_K(); ++i) {
            if (this.isReplaceable(location)) {
                return location;
            }
            if (location.func_177956_o() >= this.player.field_70170_p.func_72800_K()) break;
            location = location.func_177982_a(0, 1, 0);
        }
        throw new BlockNotFoundException("No free Block above death Location");
    }

    private boolean isReplaceable(BlockPos pos) {
        Block b = this.world.func_180495_p(pos).func_177230_c();
        if (b.func_149739_a().equals(Blocks.field_150350_a.func_149739_a())) {
            return true;
        }
        for (Block replaceableBlock : replaceableBlocks) {
            if (!b.func_149739_a().equals(replaceableBlock.func_149739_a())) continue;
            return true;
        }
        return false;
    }

    public static Block getBlock(String name) {
        try {
            String[] split = name.split(":");
            if (split.length == 2) {
                Block b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(split[0], split[1]));
                if (b.equals(Blocks.field_150350_a)) {
                    return null;
                }
                return b;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ArrayList<Block> getBlocks(String[] names) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (String s : names) {
            Block b = DeathPosition.getBlock(s);
            if (b == null) continue;
            blocks.add(b);
        }
        return blocks;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public World getWorld() {
        return this.world;
    }

    public boolean isKeepInventory() {
        return this.keepInventory;
    }

    public BlockPos getDeathPosition() {
        return this.deathPosition;
    }

    public static ArrayList<Block> getReplaceableBlocks() {
        return replaceableBlocks;
    }

    static {
        DEFAULT_BLOCKS = new String[]{"minecraft:tallgrass", "minecraft:water", "minecraft:lava", "minecraft:yellow_flower", "minecraft:red_flower", "minecraft:double_plant", "minecraft:sapling", "minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:torch", "minecraft:snow_layer", "minecraft:vine", "minecraft:deadbush", "minecraft:reeds"};
    }
}

