/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.core.settings.TickRates;
import appeng.core.sync.GuiBridge;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.PartModel;
import appeng.parts.automation.PartSharedItemBus;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.item.AEItemStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class PartImportBus
extends PartSharedItemBus
implements IInventoryDestination {
    public static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2", "part/import_bus_base");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/import_bus_off"));
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/import_bus_on"));
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, new ResourceLocation("appliedenergistics2", "part/import_bus_has_channel"));
    private final BaseActionSource source;
    private IMEInventory<IAEItemStack> destination = null;
    private IAEItemStack lastItemChecked = null;
    private int itemToSend;
    private boolean worked;

    public PartImportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.source = new MachineSource(this);
    }

    @Override
    public boolean canInsert(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        this.lastItemChecked = AEApi.instance().storage().createItemStack(stack);
        IAEItemStack out = this.destination.injectItems(this.lastItemChecked, Actionable.SIMULATE, this.source);
        if (out == null) {
            return true;
        }
        return out.getStackSize() != (long)stack.field_77994_a;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 5.0f;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), GuiBridge.GUI_BUS);
            return true;
        }
        return false;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ImportBus.getMin(), TickRates.ImportBus.getMax(), this.getHandler() == null, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.getProxy().isActive() || !this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.worked = false;
        InventoryAdaptor myAdaptor = this.getHandler();
        FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
        if (myAdaptor != null) {
            try {
                this.itemToSend = this.calculateItemsToSend();
                this.itemToSend = Math.min(this.itemToSend, (int)(0.01 + this.getProxy().getEnergy().extractAEPower((double)this.itemToSend, Actionable.SIMULATE, PowerMultiplier.CONFIG)));
                IMEMonitor<IAEItemStack> inv = this.getProxy().getStorage().getItemInventory();
                IEnergyGrid energy = this.getProxy().getEnergy();
                boolean Configured = false;
                for (int x = 0; x < this.availableSlots(); ++x) {
                    IAEItemStack ais = this.getConfig().getAEStackInSlot(x);
                    if (ais == null || this.itemToSend <= 0) continue;
                    Configured = true;
                    while (this.itemToSend > 0 && !this.importStuff(myAdaptor, ais, inv, energy, fzMode)) {
                    }
                }
                if (!Configured) {
                    while (this.itemToSend > 0) {
                        if (!this.importStuff(myAdaptor, null, inv, energy, fzMode)) continue;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            return TickRateModulation.SLEEP;
        }
        return this.worked ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    private boolean importStuff(InventoryAdaptor myAdaptor, IAEItemStack whatToImport, IMEMonitor<IAEItemStack> inv, IEnergySource energy, FuzzyMode fzMode) {
        int toSend = this.calculateMaximumAmountToImport(myAdaptor, whatToImport, inv, fzMode);
        ItemStack newItems = this.getInstalledUpgrades(Upgrades.FUZZY) > 0 ? myAdaptor.removeSimilarItems(toSend, whatToImport == null ? null : whatToImport.getItemStack(), fzMode, this.configDestination(inv)) : myAdaptor.removeItems(toSend, whatToImport == null ? null : whatToImport.getItemStack(), this.configDestination(inv));
        if (newItems != null) {
            newItems.field_77994_a = (int)(Math.min((double)newItems.field_77994_a, energy.extractAEPower(newItems.field_77994_a, Actionable.SIMULATE, PowerMultiplier.CONFIG)) + 0.01);
            this.itemToSend -= newItems.field_77994_a;
            if (this.lastItemChecked == null || !this.lastItemChecked.isSameType(newItems)) {
                this.lastItemChecked = AEApi.instance().storage().createItemStack(newItems);
            } else {
                this.lastItemChecked.setStackSize(newItems.field_77994_a);
            }
            IAEItemStack failed = Platform.poweredInsert(energy, this.destination, this.lastItemChecked, this.source);
            if (failed != null) {
                myAdaptor.addItems(failed.getItemStack());
                return true;
            }
        } else {
            return true;
        }
        this.worked = true;
        return false;
    }

    private int calculateMaximumAmountToImport(InventoryAdaptor myAdaptor, IAEItemStack whatToImport, IMEMonitor<IAEItemStack> inv, FuzzyMode fzMode) {
        IAEItemStack itemAmountNotStorable;
        ItemStack simResult;
        int toSend = Math.min(this.itemToSend, 64);
        ItemStack itemStackToImport = whatToImport == null ? null : whatToImport.getItemStack();
        if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            simResult = myAdaptor.simulateSimilarRemove(toSend, itemStackToImport, fzMode, this.configDestination(inv));
            itemAmountNotStorable = this.destination.injectItems(AEItemStack.create(simResult), Actionable.SIMULATE, this.source);
        } else {
            simResult = myAdaptor.simulateRemove(toSend, itemStackToImport, this.configDestination(inv));
            itemAmountNotStorable = this.destination.injectItems(AEItemStack.create(simResult), Actionable.SIMULATE, this.source);
        }
        if (itemAmountNotStorable != null) {
            return (int)Math.min((long)simResult.field_77994_a - itemAmountNotStorable.getStackSize(), (long)toSend);
        }
        return toSend;
    }

    private IInventoryDestination configDestination(IMEMonitor<IAEItemStack> itemInventory) {
        this.destination = itemInventory;
        return this;
    }

    @Override
    protected boolean isSleeping() {
        return this.getHandler() == null || super.isSleeping();
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

