/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.cache.NetworkMonitor;
import appeng.me.cache.SecurityCache;
import appeng.me.helpers.GenericInterestManager;
import appeng.me.storage.ItemWatcher;
import appeng.me.storage.NetworkInventoryHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class GridStorageCache
implements IStorageGrid {
    private final IGrid myGrid;
    private final HashSet<ICellProvider> activeCellProviders = new HashSet();
    private final HashSet<ICellProvider> inactiveCellProviders = new HashSet();
    private final SetMultimap<IAEStack, ItemWatcher> interests = HashMultimap.create();
    private final GenericInterestManager<ItemWatcher> interestManager = new GenericInterestManager<ItemWatcher>((Multimap<IAEStack, ItemWatcher>)this.interests);
    private final NetworkMonitor<IAEItemStack> itemMonitor = new NetworkMonitor(this, StorageChannel.ITEMS);
    private final NetworkMonitor<IAEFluidStack> fluidMonitor = new NetworkMonitor(this, StorageChannel.FLUIDS);
    private final HashMap<IGridNode, IStackWatcher> watchers = new HashMap();
    private NetworkInventoryHandler<IAEItemStack> myItemNetwork;
    private NetworkInventoryHandler<IAEFluidStack> myFluidNetwork;

    public GridStorageCache(IGrid g) {
        this.myGrid = g;
    }

    @Override
    public void onUpdateTick() {
        this.itemMonitor.onTick();
        this.fluidMonitor.onTick();
    }

    @Override
    public void removeNode(IGridNode node, IGridHost machine) {
        IStackWatcher myWatcher;
        if (machine instanceof ICellContainer) {
            ICellContainer cc = (ICellContainer)machine;
            CellChangeTracker tracker = new CellChangeTracker();
            this.removeCellProvider(cc, tracker);
            this.inactiveCellProviders.remove(cc);
            this.getGrid().postEvent(new MENetworkCellArrayUpdate());
            tracker.applyChanges();
        }
        if (machine instanceof IStackWatcherHost && (myWatcher = this.watchers.get(machine)) != null) {
            myWatcher.reset();
            this.watchers.remove(machine);
        }
    }

    @Override
    public void addNode(IGridNode node, IGridHost machine) {
        if (machine instanceof ICellContainer) {
            ICellContainer cc = (ICellContainer)machine;
            this.inactiveCellProviders.add(cc);
            this.getGrid().postEvent(new MENetworkCellArrayUpdate());
            if (node.isActive()) {
                CellChangeTracker tracker = new CellChangeTracker();
                this.addCellProvider(cc, tracker);
                tracker.applyChanges();
            }
        }
        if (machine instanceof IStackWatcherHost) {
            IStackWatcherHost swh = (IStackWatcherHost)((Object)machine);
            ItemWatcher iw = new ItemWatcher(this, swh);
            this.watchers.put(node, iw);
            swh.updateWatcher(iw);
        }
    }

    @Override
    public void onSplit(IGridStorage storageB) {
    }

    @Override
    public void onJoin(IGridStorage storageB) {
    }

    @Override
    public void populateGridStorage(IGridStorage storage) {
    }

    private CellChangeTracker addCellProvider(ICellProvider cc, CellChangeTracker tracker) {
        if (this.inactiveCellProviders.contains(cc)) {
            this.inactiveCellProviders.remove(cc);
            this.activeCellProviders.add(cc);
            BaseActionSource actionSrc = new BaseActionSource();
            if (cc instanceof IActionHost) {
                actionSrc = new MachineSource((IActionHost)((Object)cc));
            }
            for (IMEInventoryHandler h : cc.getCellArray(StorageChannel.ITEMS)) {
                tracker.postChanges(StorageChannel.ITEMS, 1, h, actionSrc);
            }
            for (IMEInventoryHandler h : cc.getCellArray(StorageChannel.FLUIDS)) {
                tracker.postChanges(StorageChannel.FLUIDS, 1, h, actionSrc);
            }
        }
        return tracker;
    }

    private CellChangeTracker removeCellProvider(ICellProvider cc, CellChangeTracker tracker) {
        if (this.activeCellProviders.contains(cc)) {
            this.activeCellProviders.remove(cc);
            this.inactiveCellProviders.add(cc);
            BaseActionSource actionSrc = new BaseActionSource();
            if (cc instanceof IActionHost) {
                actionSrc = new MachineSource((IActionHost)((Object)cc));
            }
            for (IMEInventoryHandler h : cc.getCellArray(StorageChannel.ITEMS)) {
                tracker.postChanges(StorageChannel.ITEMS, -1, h, actionSrc);
            }
            for (IMEInventoryHandler h : cc.getCellArray(StorageChannel.FLUIDS)) {
                tracker.postChanges(StorageChannel.FLUIDS, -1, h, actionSrc);
            }
        }
        return tracker;
    }

    @MENetworkEventSubscribe
    public void cellUpdate(MENetworkCellArrayUpdate ev) {
        this.myItemNetwork = null;
        this.myFluidNetwork = null;
        LinkedList<ICellProvider> ll = new LinkedList<ICellProvider>();
        ll.addAll(this.inactiveCellProviders);
        ll.addAll(this.activeCellProviders);
        CellChangeTracker tracker = new CellChangeTracker();
        for (ICellProvider cc : ll) {
            boolean active = true;
            if (cc instanceof IActionHost) {
                IGridNode node = ((IActionHost)((Object)cc)).getActionableNode();
                active = node != null && node.isActive();
            }
            if (active) {
                this.addCellProvider(cc, tracker);
                continue;
            }
            this.removeCellProvider(cc, tracker);
        }
        this.itemMonitor.forceUpdate();
        this.fluidMonitor.forceUpdate();
        tracker.applyChanges();
    }

    private void postChangesToNetwork(StorageChannel chan, int upOrDown, IItemList availableItems, BaseActionSource src) {
        switch (chan) {
            case FLUIDS: {
                this.fluidMonitor.postChange(upOrDown > 0, availableItems, src);
                break;
            }
            case ITEMS: {
                this.itemMonitor.postChange(upOrDown > 0, availableItems, src);
                break;
            }
        }
    }

    IMEInventoryHandler<IAEItemStack> getItemInventoryHandler() {
        if (this.myItemNetwork == null) {
            this.buildNetworkStorage(StorageChannel.ITEMS);
        }
        return this.myItemNetwork;
    }

    private void buildNetworkStorage(StorageChannel chan) {
        SecurityCache security = (SecurityCache)this.getGrid().getCache(ISecurityGrid.class);
        switch (chan) {
            case FLUIDS: {
                this.myFluidNetwork = new NetworkInventoryHandler(StorageChannel.FLUIDS, security);
                for (ICellProvider cc : this.activeCellProviders) {
                    for (IMEInventoryHandler h : cc.getCellArray(chan)) {
                        this.myFluidNetwork.addNewStorage(h);
                    }
                }
                break;
            }
            case ITEMS: {
                this.myItemNetwork = new NetworkInventoryHandler(StorageChannel.ITEMS, security);
                for (ICellProvider cc : this.activeCellProviders) {
                    for (IMEInventoryHandler h : cc.getCellArray(chan)) {
                        this.myItemNetwork.addNewStorage(h);
                    }
                }
                break;
            }
        }
    }

    IMEInventoryHandler<IAEFluidStack> getFluidInventoryHandler() {
        if (this.myFluidNetwork == null) {
            this.buildNetworkStorage(StorageChannel.FLUIDS);
        }
        return this.myFluidNetwork;
    }

    @Override
    public void postAlterationOfStoredItems(StorageChannel chan, Iterable<? extends IAEStack> input, BaseActionSource src) {
        if (chan == StorageChannel.ITEMS) {
            this.itemMonitor.postChange(true, input, src);
        } else if (chan == StorageChannel.FLUIDS) {
            this.fluidMonitor.postChange(true, input, src);
        }
    }

    @Override
    public void registerCellProvider(ICellProvider provider) {
        this.inactiveCellProviders.add(provider);
        this.addCellProvider(provider, new CellChangeTracker()).applyChanges();
    }

    @Override
    public void unregisterCellProvider(ICellProvider provider) {
        this.removeCellProvider(provider, new CellChangeTracker()).applyChanges();
        this.inactiveCellProviders.remove(provider);
    }

    @Override
    public IMEMonitor<IAEItemStack> getItemInventory() {
        return this.itemMonitor;
    }

    @Override
    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return this.fluidMonitor;
    }

    public GenericInterestManager<ItemWatcher> getInterestManager() {
        return this.interestManager;
    }

    IGrid getGrid() {
        return this.myGrid;
    }

    private class CellChangeTracker {
        final List<CellChangeTrackerRecord> data = new LinkedList<CellChangeTrackerRecord>();

        private CellChangeTracker() {
        }

        public void postChanges(StorageChannel channel, int i, IMEInventoryHandler<? extends IAEStack> h, BaseActionSource actionSrc) {
            this.data.add(new CellChangeTrackerRecord(channel, i, h, actionSrc));
        }

        public void applyChanges() {
            for (CellChangeTrackerRecord rec : this.data) {
                rec.applyChanges();
            }
        }
    }

    private class CellChangeTrackerRecord {
        final StorageChannel channel;
        final int up_or_down;
        final IItemList list;
        final BaseActionSource src;

        public CellChangeTrackerRecord(StorageChannel channel, int i, IMEInventoryHandler<? extends IAEStack> h, BaseActionSource actionSrc) {
            this.channel = channel;
            this.up_or_down = i;
            this.src = actionSrc;
            this.list = channel == StorageChannel.ITEMS ? h.getAvailableItems(AEApi.instance().storage().createItemList()) : (channel == StorageChannel.FLUIDS ? h.getAvailableItems(AEApi.instance().storage().createFluidList()) : null);
        }

        public void applyChanges() {
            GridStorageCache.this.postChangesToNetwork(this.channel, this.up_or_down, this.list, this.src);
        }
    }
}

