/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered.powersink;

import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.capabilities.Capabilities;
import javax.annotation.Nullable;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

class PoweredItemCapabilities
implements ICapabilityProvider,
IEnergyStorage {
    private final ItemStack is;
    private final IAEItemPowerStorage item;
    private final Object teslaAdapter;

    PoweredItemCapabilities(ItemStack is, IAEItemPowerStorage item) {
        this.is = is;
        this.item = item;
        this.teslaAdapter = Capabilities.TESLA_CONSUMER != null || Capabilities.TESLA_HOLDER != null ? new TeslaAdapter() : null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == Capabilities.TESLA_CONSUMER || capability == Capabilities.TESLA_HOLDER;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        if (capability == Capabilities.TESLA_CONSUMER || capability == Capabilities.TESLA_HOLDER) {
            return (T)this.teslaAdapter;
        }
        return null;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (simulate) {
            int required = (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.item.getAEMaxPower(this.is) - this.item.getAECurrentPower(this.is));
            if (maxReceive < required) {
                return 0;
            }
            return maxReceive - required;
        }
        double powerRemainder = this.item.injectAEPower(this.is, PowerUnits.RF.convertTo(PowerUnits.AE, maxReceive));
        return maxReceive - (int)PowerUnits.AE.convertTo(PowerUnits.RF, powerRemainder);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.item.getAECurrentPower(this.is));
    }

    public int getMaxEnergyStored() {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.item.getAEMaxPower(this.is));
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    private class TeslaAdapter
    implements ITeslaConsumer,
    ITeslaHolder {
        private TeslaAdapter() {
        }

        public long givePower(long power, boolean simulated) {
            return PoweredItemCapabilities.this.receiveEnergy((int)power, simulated);
        }

        public long getStoredPower() {
            return PoweredItemCapabilities.this.getEnergyStored();
        }

        public long getCapacity() {
            return PoweredItemCapabilities.this.getMaxEnergyStored();
        }
    }
}

