/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.api;

import appeng.api.parts.CableRenderMode;
import appeng.api.parts.IPartHelper;
import appeng.api.parts.LayerBase;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.parts.PartPlacement;
import appeng.tile.AEBaseTile;
import appeng.tile.networking.TileCableBus;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ApiPart
implements IPartHelper {
    private final LoadingCache<CacheKey, Class<? extends AEBaseTile>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, Class<? extends AEBaseTile>>(){

        public Class<? extends AEBaseTile> load(CacheKey key) throws Exception {
            return ApiPart.this.generateCombinedClass(key);
        }
    });
    private final Map<Class<?>, String> interfaces2Layer = new HashMap();
    private final List<String> desc = new LinkedList<String>();

    public Class<? extends AEBaseTile> getCombinedInstance(Class<? extends AEBaseTile> baseClass) {
        if (this.desc.isEmpty()) {
            return baseClass;
        }
        return (Class)this.cache.getUnchecked((Object)new CacheKey(baseClass, this.desc));
    }

    private Class<? extends AEBaseTile> generateCombinedClass(CacheKey cacheKey) {
        Class parentClass;
        List remainingInterfaces = cacheKey.getInterfaces().subList(1, cacheKey.getInterfaces().size());
        if (!remainingInterfaces.isEmpty()) {
            CacheKey parentKey = new CacheKey(cacheKey.getBaseClass(), remainingInterfaces);
            parentClass = (Class)this.cache.getUnchecked((Object)parentKey);
        } else {
            parentClass = cacheKey.getBaseClass();
        }
        String interfaceName = (String)cacheKey.getInterfaces().get(0);
        try {
            Class<?> interfaceClass = Class.forName(interfaceName);
            String layerImpl = this.interfaces2Layer.get(interfaceClass);
            return this.getClassByDesc(parentClass, layerImpl);
        }
        catch (Throwable t) {
            AELog.warn("Error loading " + interfaceName, new Object[0]);
            AELog.debug(t);
            return parentClass;
        }
    }

    private Class<? extends AEBaseTile> getClassByDesc(Class<? extends AEBaseTile> baseClass, String next) {
        ClassWriter cw = new ClassWriter(1);
        ClassNode n = this.getReader(next);
        String originalName = n.name;
        try {
            n.name = n.name + '_' + baseClass.getSimpleName();
            n.superName = baseClass.getName().replace('.', '/');
        }
        catch (Throwable t) {
            AELog.debug(t);
        }
        for (MethodNode mn : n.methods) {
            ListIterator i = mn.instructions.iterator();
            while (i.hasNext()) {
                this.processNode((AbstractInsnNode)i.next(), n.superName);
            }
        }
        DefaultPackageClassNameRemapper remapper = new DefaultPackageClassNameRemapper();
        remapper.inputOutput.put("appeng/api/parts/LayerBase", n.superName);
        remapper.inputOutput.put(originalName, n.name);
        n.accept((ClassVisitor)new RemappingClassAdapter((ClassVisitor)cw, (Remapper)remapper));
        byte[] byteArray = cw.toByteArray();
        int size = byteArray.length;
        Class clazz = this.loadClass(n.name.replace("/", "."), byteArray);
        try {
            Object fish = clazz.newInstance();
            boolean hasError = false;
            if (!baseClass.isInstance(fish)) {
                hasError = true;
                AELog.error("Error, Expected layer to implement " + baseClass + " did not.", new Object[0]);
            }
            if (fish instanceof LayerBase) {
                hasError = true;
                AELog.error("Error, Expected layer to NOT implement LayerBase but it DID.", new Object[0]);
            }
            if (!(fish instanceof TileCableBus)) {
                hasError = true;
                AELog.error("Error, Expected layer to implement TileCableBus did not.", new Object[0]);
            }
            if (!(fish instanceof TileEntity)) {
                hasError = true;
                AELog.error("Error, Expected layer to implement TileEntity did not.", new Object[0]);
            }
            if (!hasError) {
                AELog.info("Layer: " + n.name + " loaded successfully - " + size + " bytes", new Object[0]);
            }
        }
        catch (Throwable t) {
            AELog.error("Layer: " + n.name + " Failed.", new Object[0]);
            AELog.debug(t);
        }
        return clazz;
    }

    private ClassNode getReader(String name) {
        String path = '/' + name.replace(".", "/") + ".class";
        InputStream is = this.getClass().getResourceAsStream(path);
        try {
            ClassReader cr = new ClassReader(is);
            ClassNode cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 8);
            return cn;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error loading " + name, e);
        }
    }

    private void processNode(AbstractInsnNode next, String nePar) {
        if (next instanceof MethodInsnNode) {
            MethodInsnNode min = (MethodInsnNode)next;
            if (min.owner.equals("appeng/api/parts/LayerBase")) {
                min.owner = nePar;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClass(String name, byte[] b) {
        Class clazz = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<ClassLoader> root = ClassLoader.class;
            Class<?> cls = loader.getClass();
            Method defineClassMethod = root.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            Method runTransformersMethod = cls.getDeclaredMethod("runTransformers", String.class, String.class, byte[].class);
            runTransformersMethod.setAccessible(true);
            defineClassMethod.setAccessible(true);
            try {
                Object[] argsA = new Object[]{name, name, b};
                b = (byte[])runTransformersMethod.invoke((Object)loader, argsA);
                Object[] args = new Object[]{name, b, 0, b.length};
                clazz = (Class)defineClassMethod.invoke((Object)loader, args);
            }
            finally {
                runTransformersMethod.setAccessible(false);
                defineClassMethod.setAccessible(false);
            }
        }
        catch (Exception e) {
            AELog.debug(e);
            throw new IllegalStateException("Unable to manage part API.", e);
        }
        return clazz;
    }

    @Override
    public boolean registerNewLayer(String layer, String layerInterface) {
        try {
            Class<?> layerInterfaceClass = Class.forName(layerInterface);
            if (this.interfaces2Layer.get(layerInterfaceClass) == null) {
                this.interfaces2Layer.put(layerInterfaceClass, layer);
                this.desc.add(layerInterface);
                return true;
            }
            AELog.info("Layer " + layer + " not registered, " + layerInterface + " already has a layer.", new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public EnumActionResult placeBus(ItemStack is, BlockPos pos, EnumFacing side, EntityPlayer player, EnumHand hand, World w) {
        return PartPlacement.place(is, pos, side, player, hand, w, PartPlacement.PlaceType.PLACE_ITEM, 0);
    }

    @Override
    public CableRenderMode getCableRenderMode() {
        return CommonHelper.proxy.getRenderMode();
    }

    private static class CacheKey {
        private final Class<? extends AEBaseTile> baseClass;
        private final List<String> interfaces;

        private CacheKey(Class<? extends AEBaseTile> baseClass, List<String> interfaces) {
            this.baseClass = baseClass;
            this.interfaces = ImmutableList.copyOf(interfaces);
        }

        private Class<? extends AEBaseTile> getBaseClass() {
            return this.baseClass;
        }

        private List<String> getInterfaces() {
            return this.interfaces;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.baseClass.equals(cacheKey.baseClass) && this.interfaces.equals(cacheKey.interfaces);
        }

        public int hashCode() {
            int result = this.baseClass.hashCode();
            result = 31 * result + this.interfaces.hashCode();
            return result;
        }
    }

    private static class DefaultPackageClassNameRemapper
    extends Remapper {
        private final HashMap<String, String> inputOutput = new HashMap();

        private DefaultPackageClassNameRemapper() {
        }

        public String map(String typeName) {
            String o = this.inputOutput.get(typeName);
            if (o == null) {
                return typeName;
            }
            return o;
        }
    }
}

