/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters.grid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryNetwork
extends DynamicNetwork<TileEntity, InventoryNetwork> {
    public InventoryNetwork() {
    }

    public InventoryNetwork(Collection<InventoryNetwork> networks) {
        for (InventoryNetwork net : networks) {
            if (net == null) continue;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.register();
    }

    public List<AcceptorData> calculateAcceptors(TransitRequest request, EnumColor color) {
        ArrayList<AcceptorData> toReturn = new ArrayList<AcceptorData>();
        for (Coord4D coord : this.possibleAcceptors.keySet()) {
            if (coord == null) continue;
            EnumSet sides = (EnumSet)this.acceptorDirections.get(coord);
            TileEntity acceptor = coord.getTileEntity((IBlockAccess)this.getWorld());
            if (sides == null || sides.isEmpty()) continue;
            AcceptorData data = null;
            for (EnumFacing side : sides) {
                TransitRequest.TransitResponse response = TransporterManager.getPredictedInsert(acceptor, color, request, side.func_176734_d());
                if (response.isEmpty()) continue;
                if (data == null) {
                    data = new AcceptorData(coord, response, side.func_176734_d());
                    continue;
                }
                data.sides.add(side.func_176734_d());
            }
            if (data == null) continue;
            toReturn.add(data);
        }
        return toReturn;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            // empty if block
        }
    }

    @Override
    public void absorbBuffer(IGridTransmitter<TileEntity, InventoryNetwork> transmitter) {
    }

    @Override
    public void clampBuffer() {
    }

    @Override
    public Set<Pair<Coord4D, TileEntity>> getAcceptors(Object data) {
        HashSet<Pair<Coord4D, TileEntity>> toReturn = new HashSet<Pair<Coord4D, TileEntity>>();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return toReturn;
        }
        return toReturn;
    }

    public String toString() {
        return "[InventoryNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public String getNeededInfo() {
        return null;
    }

    @Override
    public String getStoredInfo() {
        return null;
    }

    @Override
    public String getFlowInfo() {
        return null;
    }

    public static class AcceptorData {
        public Coord4D location;
        public TransitRequest.TransitResponse response;
        public EnumSet<EnumFacing> sides = EnumSet.noneOf(EnumFacing.class);

        public AcceptorData(Coord4D coord, TransitRequest.TransitResponse ret, EnumFacing side) {
            this.location = coord;
            this.response = ret;
            this.sides.add(side);
        }
    }
}

