/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import mekanism.common.Upgrade;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ItemHandlerWrapper;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityContainerBlock
extends TileEntityBasicBlock
implements ISidedInventory,
ISustainedInventory,
ITickable {
    public ItemStack[] inventory;
    public String fullName;
    private CapabilityWrapperManager itemManager = new CapabilityWrapperManager<ISidedInventory, ItemHandlerWrapper>(ISidedInventory.class, ItemHandlerWrapper.class);

    public TileEntityContainerBlock(String name) {
        this.fullName = name;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (this.handleInventory()) {
            NBTTagList tagList = nbtTags.func_150295_c("Items", 10);
            this.inventory = new ItemStack[this.func_70302_i_()];
            for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
                NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
                byte slotID = tagCompound.func_74771_c("Slot");
                if (slotID < 0 || slotID >= this.func_70302_i_()) continue;
                this.func_70299_a(slotID, ItemStack.func_77949_a((NBTTagCompound)tagCompound));
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.handleInventory()) {
            NBTTagList tagList = new NBTTagList();
            for (int slotCount = 0; slotCount < this.func_70302_i_(); ++slotCount) {
                if (this.func_70301_a(slotCount) == null) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)slotCount);
                this.func_70301_a(slotCount).func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            nbtTags.func_74782_a("Items", (NBTBase)tagList);
        }
        return nbtTags;
    }

    public int func_70302_i_() {
        return this.inventory != null ? this.inventory.length : 0;
    }

    public ItemStack func_70301_a(int slotID) {
        return this.inventory != null ? this.inventory[slotID] : null;
    }

    public ItemStack func_70298_a(int slotID, int amount) {
        if (this.inventory == null) {
            return null;
        }
        return ItemStackHelper.func_188382_a((ItemStack[])this.inventory, (int)slotID, (int)amount);
    }

    public ItemStack func_70304_b(int slotID) {
        if (this.inventory == null) {
            return null;
        }
        return ItemStackHelper.func_188383_a((ItemStack[])this.inventory, (int)slotID);
    }

    public void func_70299_a(int slotID, ItemStack itemstack) {
        this.inventory[slotID] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return !this.func_145837_r();
    }

    public String func_70005_c_() {
        return LangUtils.localize(this.func_145838_q().func_149739_a() + "." + this.fullName + ".name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return true;
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public int[] func_180463_a(EnumFacing side) {
        return InventoryUtils.EMPTY;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return true;
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (nbtTags == null || nbtTags.func_74745_c() == 0 || !this.handleInventory()) {
            return;
        }
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int slots = 0; slots < nbtTags.func_74745_c(); ++slots) {
            NBTTagCompound tagCompound = nbtTags.func_150305_b(slots);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.length) continue;
            this.inventory[slotID] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        NBTTagList tagList = new NBTTagList();
        if (this.handleInventory()) {
            for (int slots = 0; slots < this.inventory.length; ++slots) {
                if (this.inventory[slots] == null) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)slots);
                this.inventory[slots].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
        }
        return tagList;
    }

    public boolean handleInventory() {
        return true;
    }

    public void recalculateUpgradables(Upgrade upgradeType) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemManager.getWrapper(this, facing);
        }
        return super.getCapability(capability, facing);
    }
}

