/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import cofh.api.energy.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.entity.EntityRobit;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.prefab.TileEntityNoisyBlock;
import mekanism.common.util.MekanismUtils;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityChargepad
extends TileEntityNoisyBlock {
    public boolean isActive;
    public boolean clientActive;
    public Random random = new Random();

    public TileEntityChargepad() {
        super("machine.chargepad", "Chargepad", BlockStateMachine.MachineType.CHARGEPAD.baseEnergy);
        this.inventory = new ItemStack[0];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            this.isActive = false;
            List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)this.func_174877_v().func_177956_o() + 0.2, (double)(this.func_174877_v().func_177952_p() + 1)));
            block0: for (EntityLivingBase entity : entities) {
                if (entity instanceof EntityPlayer || entity instanceof EntityRobit) {
                    this.isActive = true;
                }
                if (!(this.getEnergy() > 0.0)) continue;
                if (entity instanceof EntityRobit) {
                    EntityRobit robit = (EntityRobit)entity;
                    double canGive = Math.min(this.getEnergy(), 1000.0);
                    double toGive = Math.min(robit.MAX_ELECTRICITY - robit.getEnergy(), canGive);
                    robit.setEnergy(robit.getEnergy() + toGive);
                    this.setEnergy(this.getEnergy() - toGive);
                    continue;
                }
                if (!(entity instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)entity;
                double prevEnergy = this.getEnergy();
                for (ItemStack itemstack : player.field_71071_by.field_70460_b) {
                    this.chargeItemStack(itemstack);
                    if (prevEnergy != this.getEnergy()) break;
                }
                for (ItemStack itemstack : player.field_71071_by.field_70462_a) {
                    this.chargeItemStack(itemstack);
                    if (prevEnergy != this.getEnergy()) continue block0;
                }
            }
            if (this.clientActive != this.isActive) {
                if (this.isActive) {
                    this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.1, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.8f);
                } else {
                    this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.1, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187847_fZ, SoundCategory.BLOCKS, 0.3f, 0.7f);
                }
                this.setActive(this.isActive);
            }
        } else if (this.isActive) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, (double)this.func_174877_v().func_177958_n() + this.random.nextDouble(), (double)this.func_174877_v().func_177956_o() + 0.15, (double)this.func_174877_v().func_177952_p() + this.random.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void chargeItemStack(ItemStack itemstack) {
        if (itemstack != null) {
            if (itemstack.func_77973_b() instanceof IEnergizedItem) {
                this.setEnergy(this.getEnergy() - EnergizedItemManager.charge(itemstack, this.getEnergy()));
            } else if (MekanismUtils.useTesla() && itemstack.hasCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null)) {
                ITeslaConsumer consumer = (ITeslaConsumer)itemstack.getCapability(Capabilities.TESLA_CONSUMER_CAPABILITY, null);
                long stored = Math.round(this.getEnergy() * MekanismConfig.general.TO_TESLA);
                this.setEnergy(this.getEnergy() - (double)consumer.givePower(stored, false) * MekanismConfig.general.FROM_TESLA);
            } else if (MekanismUtils.useForge() && itemstack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                IEnergyStorage storage = (IEnergyStorage)itemstack.getCapability(CapabilityEnergy.ENERGY, null);
                if (storage.canReceive()) {
                    int stored = (int)Math.round(Math.min(2.147483647E9, this.getEnergy() * MekanismConfig.general.TO_FORGE));
                    this.setEnergy(this.getEnergy() - (double)storage.receiveEnergy(stored, false) * MekanismConfig.general.FROM_FORGE);
                }
            } else if (MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem) {
                IEnergyContainerItem item = (IEnergyContainerItem)itemstack.func_77973_b();
                int toTransfer = (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_RF);
                this.setEnergy(this.getEnergy() - (double)item.receiveEnergy(itemstack, toTransfer, false) * MekanismConfig.general.FROM_RF);
            } else if (MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof IElectricItem) {
                double sent = ElectricItem.manager.charge(itemstack, this.getEnergy() * MekanismConfig.general.TO_IC2, 4, true, false) * MekanismConfig.general.FROM_IC2;
                this.setEnergy(this.getEnergy() - sent);
            }
        }
    }

    @Override
    public EnumSet<EnumFacing> getConsumingSides() {
        return EnumSet.of(EnumFacing.DOWN, this.facing.func_176734_d());
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList<Object>())), new Range4D(Coord4D.get(this)));
        }
        this.clientActive = active;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        return nbtTags;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.clientActive = dataStream.readBoolean();
            if (this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        return data;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getVolume() {
        return 0.4f * super.getVolume();
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }
}

