/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.INormallyOccludingPart;
import mcmultipart.multipart.Multipart;
import mcmultipart.multipart.OcclusionHelper;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.transmitters.IBlockableConnection;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismItems;
import mekanism.common.Tier;
import mekanism.common.base.ITileNetwork;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.multipart.ColorProperty;
import mekanism.common.multipart.ConnectionProperty;
import mekanism.common.multipart.MultipartMekanism;
import mekanism.common.multipart.PartDiversionTransporter;
import mekanism.common.multipart.PartLogisticalTransporter;
import mekanism.common.multipart.PartMechanicalPipe;
import mekanism.common.multipart.PartPressurizedTube;
import mekanism.common.multipart.PartRestrictiveTransporter;
import mekanism.common.multipart.PartThermodynamicConductor;
import mekanism.common.multipart.PartUniversalCable;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class PartSidedPipe
extends Multipart
implements INormallyOccludingPart,
ITileNetwork,
IBlockableConnection,
IConfigurable,
ITransmitter,
ITickable {
    public static AxisAlignedBB[] smallSides = new AxisAlignedBB[7];
    public static AxisAlignedBB[] largeSides = new AxisAlignedBB[7];
    public int delayTicks;
    public EnumFacing testingSide = null;
    public byte currentAcceptorConnections = 0;
    public byte currentTransmitterConnections = 0;
    public boolean sendDesc = false;
    public boolean redstonePowered = false;
    public boolean redstoneReactive = false;
    public boolean forceUpdate = true;
    public boolean redstoneSet = false;
    public ConnectionType[] connectionTypes = new ConnectionType[]{ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL};
    public TileEntity[] cachedAcceptors = new TileEntity[6];

    public static IMultipart getPartType(TransmitterType type) {
        switch (type) {
            case UNIVERSAL_CABLE_BASIC: {
                return new PartUniversalCable(Tier.CableTier.BASIC);
            }
            case UNIVERSAL_CABLE_ADVANCED: {
                return new PartUniversalCable(Tier.CableTier.ADVANCED);
            }
            case UNIVERSAL_CABLE_ELITE: {
                return new PartUniversalCable(Tier.CableTier.ELITE);
            }
            case UNIVERSAL_CABLE_ULTIMATE: {
                return new PartUniversalCable(Tier.CableTier.ULTIMATE);
            }
            case MECHANICAL_PIPE_BASIC: {
                return new PartMechanicalPipe(Tier.PipeTier.BASIC);
            }
            case MECHANICAL_PIPE_ADVANCED: {
                return new PartMechanicalPipe(Tier.PipeTier.ADVANCED);
            }
            case MECHANICAL_PIPE_ELITE: {
                return new PartMechanicalPipe(Tier.PipeTier.ELITE);
            }
            case MECHANICAL_PIPE_ULTIMATE: {
                return new PartMechanicalPipe(Tier.PipeTier.ULTIMATE);
            }
            case PRESSURIZED_TUBE_BASIC: {
                return new PartPressurizedTube(Tier.TubeTier.BASIC);
            }
            case PRESSURIZED_TUBE_ADVANCED: {
                return new PartPressurizedTube(Tier.TubeTier.ADVANCED);
            }
            case PRESSURIZED_TUBE_ELITE: {
                return new PartPressurizedTube(Tier.TubeTier.ELITE);
            }
            case PRESSURIZED_TUBE_ULTIMATE: {
                return new PartPressurizedTube(Tier.TubeTier.ULTIMATE);
            }
            case LOGISTICAL_TRANSPORTER_BASIC: {
                return new PartLogisticalTransporter(Tier.TransporterTier.BASIC);
            }
            case LOGISTICAL_TRANSPORTER_ADVANCED: {
                return new PartLogisticalTransporter(Tier.TransporterTier.ADVANCED);
            }
            case LOGISTICAL_TRANSPORTER_ELITE: {
                return new PartLogisticalTransporter(Tier.TransporterTier.ELITE);
            }
            case LOGISTICAL_TRANSPORTER_ULTIMATE: {
                return new PartLogisticalTransporter(Tier.TransporterTier.ULTIMATE);
            }
            case RESTRICTIVE_TRANSPORTER: {
                return new PartRestrictiveTransporter();
            }
            case DIVERSION_TRANSPORTER: {
                return new PartDiversionTransporter();
            }
            case THERMODYNAMIC_CONDUCTOR_BASIC: {
                return new PartThermodynamicConductor(Tier.ConductorTier.BASIC);
            }
            case THERMODYNAMIC_CONDUCTOR_ADVANCED: {
                return new PartThermodynamicConductor(Tier.ConductorTier.ADVANCED);
            }
            case THERMODYNAMIC_CONDUCTOR_ELITE: {
                return new PartThermodynamicConductor(Tier.ConductorTier.ELITE);
            }
            case THERMODYNAMIC_CONDUCTOR_ULTIMATE: {
                return new PartThermodynamicConductor(Tier.ConductorTier.ULTIMATE);
            }
        }
        return null;
    }

    public static boolean connectionMapContainsSide(byte connections, EnumFacing side) {
        byte tester = (byte)(1 << side.ordinal());
        return (connections & tester) > 0;
    }

    public static byte setConnectionBit(byte connections, boolean toSet, EnumFacing side) {
        return (byte)(connections & ~((byte)(1 << side.ordinal())) | (byte)((toSet ? 1 : 0) << side.ordinal()));
    }

    public void func_73660_a() {
        if (this.getWorld().field_72995_K) {
            if (this.delayTicks == 5) {
                this.delayTicks = 6;
                this.refreshConnections();
            } else if (this.delayTicks < 5) {
                ++this.delayTicks;
            }
        }
        if (!this.getWorld().field_72995_K) {
            if (this.forceUpdate) {
                this.refreshConnections();
                this.forceUpdate = false;
            }
            if (this.sendDesc) {
                this.sendUpdatePacket();
                this.sendDesc = false;
            }
        }
    }

    public boolean handlesRedstone() {
        return true;
    }

    public boolean renderCenter() {
        return false;
    }

    public boolean transparencyRender() {
        return false;
    }

    public byte getPossibleTransmitterConnections() {
        byte connections = 0;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return connections;
        }
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity tileEntity;
            if (!this.canConnectMutual(side) || (tileEntity = this.getWorld().func_175625_s(this.getPos().func_177972_a(side))) == null || !CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()) || !TransmissionType.checkTransmissionType(CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()), this.getTransmitterType().getTransmission()) || !this.isValidTransmitter(tileEntity)) continue;
            connections = (byte)(connections | 1 << side.ordinal());
        }
        return connections;
    }

    public boolean getPossibleAcceptorConnection(EnumFacing side) {
        TileEntity tileEntity;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return false;
        }
        if (this.canConnectMutual(side) && this.isValidAcceptor(tileEntity = this.getWorld().func_175625_s(this.getPos().func_177972_a(side)), side)) {
            if (this.cachedAcceptors[side.ordinal()] != tileEntity) {
                this.cachedAcceptors[side.ordinal()] = tileEntity;
                this.markDirtyAcceptor(side);
            }
            return true;
        }
        if (this.cachedAcceptors[side.ordinal()] != null) {
            this.cachedAcceptors[side.ordinal()] = null;
            this.markDirtyAcceptor(side);
        }
        return false;
    }

    public boolean getPossibleTransmitterConnection(EnumFacing side) {
        TileEntity tileEntity;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return false;
        }
        return this.canConnectMutual(side) && CapabilityUtils.hasCapability((ICapabilityProvider)(tileEntity = this.getWorld().func_175625_s(this.getPos().func_177972_a(side))), Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()) && TransmissionType.checkTransmissionType(CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()), this.getTransmitterType().getTransmission()) && this.isValidTransmitter(tileEntity);
    }

    public byte getPossibleAcceptorConnections() {
        byte connections = 0;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return connections;
        }
        for (EnumFacing side : EnumFacing.values()) {
            if (this.canConnectMutual(side)) {
                Coord4D coord = new Coord4D(this.getPos(), this.getWorld()).offset(side);
                if (!this.getWorld().field_72995_K && !coord.exists(this.getWorld())) {
                    this.forceUpdate = true;
                    continue;
                }
                TileEntity tileEntity = coord.getTileEntity((IBlockAccess)this.getWorld());
                if (this.isValidAcceptor(tileEntity, side)) {
                    if (this.cachedAcceptors[side.ordinal()] != tileEntity) {
                        this.cachedAcceptors[side.ordinal()] = tileEntity;
                        this.markDirtyAcceptor(side);
                    }
                    connections = (byte)(connections | 1 << side.ordinal());
                    continue;
                }
            }
            if (this.cachedAcceptors[side.ordinal()] == null) continue;
            this.cachedAcceptors[side.ordinal()] = null;
            this.markDirtyAcceptor(side);
        }
        return connections;
    }

    public byte getAllCurrentConnections() {
        return (byte)(this.currentTransmitterConnections | this.currentAcceptorConnections);
    }

    protected boolean isValidTransmitter(TileEntity tileEntity) {
        return true;
    }

    public float getHardness(PartMOP partHit) {
        return 3.5f;
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        if (this.getContainer() != null) {
            for (EnumFacing side : EnumFacing.values()) {
                int ord = side.ordinal();
                byte connections = this.getAllCurrentConnections();
                if (!PartSidedPipe.connectionMapContainsSide(connections, side) && side != this.testingSide) continue;
                list.add(this.getTransmitterType().getSize() == TransmitterType.Size.SMALL ? smallSides[ord] : largeSides[ord]);
            }
        }
        list.add(this.getTransmitterType().getSize() == TransmitterType.Size.SMALL ? smallSides[6] : largeSides[6]);
    }

    public abstract TransmitterType getTransmitterType();

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB box;
        if (this.getContainer() != null) {
            for (EnumFacing side : EnumFacing.values()) {
                AxisAlignedBB box2;
                int ord = side.ordinal();
                byte connections = this.getAllCurrentConnections();
                if (!PartSidedPipe.connectionMapContainsSide(connections, side) && side != this.testingSide) continue;
                AxisAlignedBB axisAlignedBB = box2 = this.getTransmitterType().getSize() == TransmitterType.Size.SMALL ? smallSides[ord] : largeSides[ord];
                if (!box2.func_72326_a(mask)) continue;
                list.add(box2);
            }
        }
        AxisAlignedBB axisAlignedBB = box = this.getTransmitterType().getSize() == TransmitterType.Size.SMALL ? smallSides[6] : largeSides[6];
        if (box.func_72326_a(mask)) {
            list.add(box);
        }
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        this.addSelectionBoxes(list);
    }

    public abstract boolean isValidAcceptor(TileEntity var1, EnumFacing var2);

    @Override
    public boolean canConnectMutual(EnumFacing side) {
        if (!this.canConnect(side)) {
            return false;
        }
        TileEntity tile = this.getWorld().func_175625_s(this.getPos().func_177972_a(side));
        if (!CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.BLOCKABLE_CONNECTION_CAPABILITY, side.func_176734_d())) {
            return true;
        }
        return CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.BLOCKABLE_CONNECTION_CAPABILITY, side.func_176734_d()).canConnect(side.func_176734_d());
    }

    @Override
    public boolean canConnect(EnumFacing side) {
        if (!this.redstoneSet) {
            this.redstonePowered = this.redstoneReactive ? MekanismUtils.isGettingPowered(this.getWorld(), new Coord4D(this.getPos(), this.getWorld())) : false;
            this.redstoneSet = true;
        }
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return false;
        }
        this.testingSide = side;
        OcclusionHelper.NormallyOccludingPart testPart = new OcclusionHelper.NormallyOccludingPart(new AxisAlignedBB[]{this.getTransmitterType().getSize() == TransmitterType.Size.SMALL ? smallSides[side.ordinal()] : largeSides[side.ordinal()]});
        boolean unblocked = OcclusionHelper.occlusionTest((IMultipart)testPart, part -> part == this, (Iterable)this.getContainer().getParts());
        this.testingSide = null;
        return unblocked;
    }

    public void readUpdatePacket(PacketBuffer packet) {
        this.currentTransmitterConnections = packet.readByte();
        this.currentAcceptorConnections = packet.readByte();
        for (int i = 0; i < 6; ++i) {
            this.connectionTypes[i] = ConnectionType.values()[packet.readInt()];
        }
        this.notifyPartUpdate();
        this.markRenderUpdate();
    }

    public void writeUpdatePacket(PacketBuffer packet) {
        packet.writeByte((int)this.currentTransmitterConnections);
        packet.writeByte((int)this.currentAcceptorConnections);
        for (int i = 0; i < 6; ++i) {
            packet.writeInt(this.connectionTypes[i].ordinal());
        }
    }

    public void readFromNBT(NBTTagCompound nbtTags) {
        super.readFromNBT(nbtTags);
        this.redstoneReactive = nbtTags.func_74767_n("redstoneReactive");
        for (int i = 0; i < 6; ++i) {
            this.connectionTypes[i] = ConnectionType.values()[nbtTags.func_74762_e("connection" + i)];
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbtTags) {
        super.writeToNBT(nbtTags);
        nbtTags.func_74757_a("redstoneReactive", this.redstoneReactive);
        for (int i = 0; i < 6; ++i) {
            nbtTags.func_74768_a("connection" + i, this.connectionTypes[i].ordinal());
        }
        return nbtTags;
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit) {
        if (stack == null) {
            return false;
        }
        if (MekanismUtils.hasUsableWrench(player, this.getPos()) && player.func_70093_af()) {
            if (!this.getWorld().field_72995_K) {
                MultipartMekanism.dropItems(this);
                this.getContainer().removePart((IMultipart)this);
            }
            return true;
        }
        return false;
    }

    public List<ItemStack> getDrops() {
        return Collections.singletonList(this.getPickBlock(null, null));
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return new ItemStack(MekanismItems.PartTransmitter, 1, this.getTransmitterType().ordinal());
    }

    protected void onRefresh() {
    }

    public void refreshConnections() {
        this.redstonePowered = this.redstoneReactive ? MekanismUtils.isGettingPowered(this.getWorld(), new Coord4D(this.getPos(), this.getWorld())) : false;
        this.redstoneSet = true;
        if (!this.getWorld().field_72995_K) {
            byte possibleAcceptors;
            byte possibleTransmitters = this.getPossibleTransmitterConnections();
            if ((possibleTransmitters | (possibleAcceptors = this.getPossibleAcceptorConnections())) != this.getAllCurrentConnections()) {
                this.sendDesc = true;
            }
            this.currentTransmitterConnections = possibleTransmitters;
            this.currentAcceptorConnections = possibleAcceptors;
        }
    }

    public void refreshConnections(EnumFacing side) {
        if (!this.getWorld().field_72995_K) {
            boolean possibleTransmitter = this.getPossibleTransmitterConnection(side);
            boolean possibleAcceptor = this.getPossibleAcceptorConnection(side);
            if ((possibleTransmitter || possibleAcceptor) != PartSidedPipe.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
                this.sendDesc = true;
            }
            this.currentTransmitterConnections = PartSidedPipe.setConnectionBit(this.currentTransmitterConnections, possibleTransmitter, side);
            this.currentAcceptorConnections = PartSidedPipe.setConnectionBit(this.currentAcceptorConnections, possibleAcceptor, side);
        }
    }

    protected void onModeChange(EnumFacing side) {
        this.markDirtyAcceptor(side);
    }

    protected void markDirtyTransmitters() {
        this.notifyTileChange();
    }

    protected void markDirtyAcceptor(EnumFacing side) {
    }

    public abstract void onWorldJoin();

    public abstract void onWorldSeparate();

    public void onRemoved() {
        this.onWorldSeparate();
        super.onRemoved();
    }

    public void onUnloaded() {
        this.onWorldSeparate();
        super.onRemoved();
    }

    public void onAdded() {
        this.onWorldJoin();
        super.onAdded();
        this.refreshConnections();
    }

    public void onLoaded() {
        this.onWorldJoin();
        super.onLoaded();
    }

    public void onNeighborTileChange(EnumFacing side) {
        this.refreshConnections(side);
    }

    public void onNeighborBlockChange(Block block) {
        if (this.handlesRedstone()) {
            boolean prevPowered = this.redstonePowered;
            this.refreshConnections();
            if (prevPowered != this.redstonePowered) {
                this.markDirtyTransmitters();
            }
        } else {
            this.refreshConnections();
        }
    }

    public void onPartChanged(IMultipart part) {
        super.onPartChanged(part);
        byte transmittersBefore = this.currentTransmitterConnections;
        this.refreshConnections();
        if (transmittersBefore != this.currentTransmitterConnections) {
            this.markDirtyTransmitters();
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        return data;
    }

    public ConnectionType getConnectionType(EnumFacing side) {
        return PartSidedPipe.getConnectionType(side, this.getAllCurrentConnections(), this.currentTransmitterConnections, this.connectionTypes);
    }

    public static ConnectionType getConnectionType(EnumFacing side, byte allConnections, byte transmitterConnections, ConnectionType[] types) {
        if (!PartSidedPipe.connectionMapContainsSide(allConnections, side)) {
            return ConnectionType.NONE;
        }
        if (PartSidedPipe.connectionMapContainsSide(transmitterConnections, side)) {
            return ConnectionType.NORMAL;
        }
        return types[side.ordinal()];
    }

    public List<EnumFacing> getConnections(ConnectionType type) {
        ArrayList<EnumFacing> sides = new ArrayList<EnumFacing>();
        for (EnumFacing side : EnumFacing.values()) {
            if (this.getConnectionType(side) != type) continue;
            sides.add(side);
        }
        return sides;
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.getWorld().field_72995_K) {
            PartMOP hit = this.reTrace(this.getWorld(), this.getPos(), player);
            if (hit == null) {
                return EnumActionResult.PASS;
            }
            EnumFacing hitSide = this.sideHit(hit.subHit + 1);
            if (hitSide != null) {
                this.connectionTypes[hitSide.ordinal()] = this.connectionTypes[hitSide.ordinal()].next();
                this.sendDesc = true;
                this.onModeChange(EnumFacing.func_82600_a((int)hitSide.ordinal()));
                player.func_145747_a((ITextComponent)new TextComponentString("Connection type changed to " + this.connectionTypes[hitSide.ordinal()].toString()));
                return EnumActionResult.SUCCESS;
            }
            return this.onConfigure(player, 6, side);
        }
        return EnumActionResult.SUCCESS;
    }

    private PartMOP reTrace(World world, BlockPos pos, EntityPlayer player) {
        Vec3d start = RayTraceUtils.getStart((EntityPlayer)player);
        Vec3d end = RayTraceUtils.getEnd((EntityPlayer)player);
        RayTraceUtils.AdvancedRayTraceResultPart result = ((TileMultipartContainer)world.func_175625_s(pos)).getPartContainer().collisionRayTrace(start, end);
        return result == null ? null : (PartMOP)result.hit;
    }

    protected EnumFacing sideHit(int boxIndex) {
        ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
        if (this.getContainer() != null) {
            for (EnumFacing side : EnumFacing.values()) {
                int ord = side.ordinal();
                byte connections = this.getAllCurrentConnections();
                if (!PartSidedPipe.connectionMapContainsSide(connections, side)) continue;
                list.add(side);
            }
        }
        if (boxIndex < list.size()) {
            return (EnumFacing)list.get(boxIndex);
        }
        return null;
    }

    protected EnumActionResult onConfigure(EntityPlayer player, int part, EnumFacing side) {
        return EnumActionResult.PASS;
    }

    public EnumColor getRenderColor() {
        return null;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.getWorld().field_72995_K && this.handlesRedstone()) {
            this.redstoneReactive ^= true;
            this.refreshConnections();
            this.notifyTileChange();
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " Redstone sensitivity turned " + (Object)((Object)EnumColor.INDIGO) + (this.redstoneReactive ? "on." : "off.")));
        }
        return EnumActionResult.SUCCESS;
    }

    public ResourceLocation getModelPath() {
        return this.getType();
    }

    public BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)MCMultiPartMod.multipart, new IProperty[0], new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE, ColorProperty.INSTANCE, ConnectionProperty.INSTANCE});
    }

    public List<String> getVisibleGroups() {
        ArrayList<String> visible = new ArrayList<String>();
        for (EnumFacing side : EnumFacing.values()) {
            visible.add(side.func_176610_l() + this.getConnectionType(side).func_176610_l().toUpperCase());
        }
        return visible;
    }

    public IBlockState getExtendedState(IBlockState state) {
        ConnectionProperty connectionProp = new ConnectionProperty(this.getAllCurrentConnections(), this.currentTransmitterConnections, this.connectionTypes, this.renderCenter());
        return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE, (Object)new OBJModel.OBJState(this.getVisibleGroups(), true)).withProperty((IUnlistedProperty)ConnectionProperty.INSTANCE, (Object)connectionProp);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT || this.transparencyRender() && layer == BlockRenderLayer.TRANSLUCENT;
    }

    public void notifyTileChange() {
        MekanismUtils.notifyLoadedNeighborsOfTileChange(this.getWorld(), new Coord4D(this.getPos(), this.getWorld()));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == Capabilities.TILE_NETWORK_CAPABILITY || capability == Capabilities.BLOCKABLE_CONNECTION_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == Capabilities.TILE_NETWORK_CAPABILITY || capability == Capabilities.BLOCKABLE_CONNECTION_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldBreakingUseExtendedState() {
        return true;
    }

    static {
        PartSidedPipe.smallSides[0] = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.3, 0.7);
        PartSidedPipe.smallSides[1] = new AxisAlignedBB(0.3, 0.7, 0.3, 0.7, 1.0, 0.7);
        PartSidedPipe.smallSides[2] = new AxisAlignedBB(0.3, 0.3, 0.0, 0.7, 0.7, 0.3);
        PartSidedPipe.smallSides[3] = new AxisAlignedBB(0.3, 0.3, 0.7, 0.7, 0.7, 1.0);
        PartSidedPipe.smallSides[4] = new AxisAlignedBB(0.0, 0.3, 0.3, 0.3, 0.7, 0.7);
        PartSidedPipe.smallSides[5] = new AxisAlignedBB(0.7, 0.3, 0.3, 1.0, 0.7, 0.7);
        PartSidedPipe.smallSides[6] = new AxisAlignedBB(0.3, 0.3, 0.3, 0.7, 0.7, 0.7);
        PartSidedPipe.largeSides[0] = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.25, 0.75);
        PartSidedPipe.largeSides[1] = new AxisAlignedBB(0.25, 0.75, 0.25, 0.75, 1.0, 0.75);
        PartSidedPipe.largeSides[2] = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.25);
        PartSidedPipe.largeSides[3] = new AxisAlignedBB(0.25, 0.25, 0.75, 0.75, 0.75, 1.0);
        PartSidedPipe.largeSides[4] = new AxisAlignedBB(0.0, 0.25, 0.25, 0.25, 0.75, 0.75);
        PartSidedPipe.largeSides[5] = new AxisAlignedBB(0.75, 0.25, 0.25, 1.0, 0.75, 0.75);
        PartSidedPipe.largeSides[6] = new AxisAlignedBB(0.25, 0.25, 0.25, 0.75, 0.75, 0.75);
    }

    public static enum ConnectionType implements IStringSerializable
    {
        NORMAL,
        PUSH,
        PULL,
        NONE;


        public ConnectionType next() {
            if (this.ordinal() == ConnectionType.values().length - 1) {
                return NORMAL;
            }
            return ConnectionType.values()[this.ordinal() + 1];
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

