/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.forgeenergy;

import mekanism.common.base.IEnergyWrapper;
import mekanism.common.config.MekanismConfig;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergyIntegration
implements IEnergyStorage {
    public IEnergyWrapper tileEntity;
    public EnumFacing side;

    public ForgeEnergyIntegration(IEnergyWrapper tile, EnumFacing facing) {
        this.tileEntity = tile;
        this.side = facing;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return ForgeEnergyIntegration.rfToForge(this.tileEntity.receiveEnergy(this.side, ForgeEnergyIntegration.forgeToRF(maxReceive), simulate));
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return ForgeEnergyIntegration.rfToForge(this.tileEntity.extractEnergy(this.side, ForgeEnergyIntegration.forgeToRF(maxExtract), simulate));
    }

    public int getEnergyStored() {
        return (int)Math.round(Math.min(2.147483647E9, this.tileEntity.getEnergy() * MekanismConfig.general.TO_FORGE));
    }

    public int getMaxEnergyStored() {
        return (int)Math.round(Math.min(2.147483647E9, this.tileEntity.getMaxEnergy() * MekanismConfig.general.TO_FORGE));
    }

    public boolean canExtract() {
        return this.tileEntity.getOutputtingSides().contains(this.side);
    }

    public boolean canReceive() {
        return this.tileEntity.getConsumingSides().contains(this.side);
    }

    public static int rfToForge(int rf) {
        return (int)Math.round((double)rf * MekanismConfig.general.FROM_RF * MekanismConfig.general.TO_FORGE);
    }

    public static int forgeToRF(int forge) {
        return (int)Math.round((double)forge * MekanismConfig.general.FROM_FORGE * MekanismConfig.general.TO_RF);
    }
}

