/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import mekanism.api.Coord4D;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class EnergyAcceptorWrapper
implements IStrictEnergyAcceptor {
    public Coord4D coord;

    public static EnergyAcceptorWrapper get(TileEntity tileEntity, EnumFacing side) {
        IEnergyTile tile;
        if (tileEntity == null || tileEntity.func_145831_w() == null) {
            return null;
        }
        EnergyAcceptorWrapper wrapper = null;
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_ACCEPTOR_CAPABILITY, side)) {
            wrapper = new MekanismAcceptor(CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.ENERGY_ACCEPTOR_CAPABILITY, side));
        } else if (MekanismUtils.useTesla() && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.TESLA_CONSUMER_CAPABILITY, side)) {
            wrapper = new TeslaAcceptor(CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.TESLA_CONSUMER_CAPABILITY, side));
        } else if (MekanismUtils.useForge() && CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, side)) {
            wrapper = new ForgeAcceptor((IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, CapabilityEnergy.ENERGY, side));
        } else if (MekanismUtils.useRF() && tileEntity instanceof IEnergyReceiver) {
            wrapper = new RFAcceptor((IEnergyReceiver)tileEntity);
        } else if (MekanismUtils.useIC2() && (tile = EnergyNet.instance.getSubTile(tileEntity.func_145831_w(), tileEntity.func_174877_v())) instanceof IEnergySink) {
            wrapper = new IC2Acceptor((IEnergySink)tile);
        }
        if (wrapper != null) {
            wrapper.coord = Coord4D.get(tileEntity);
        }
        return wrapper;
    }

    public abstract boolean needsEnergy(EnumFacing var1);

    public static class ForgeAcceptor
    extends EnergyAcceptorWrapper {
        private IEnergyStorage acceptor;

        public ForgeAcceptor(IEnergyStorage forgeConsumer) {
            this.acceptor = forgeConsumer;
        }

        @Override
        public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
            return this.fromForge(this.acceptor.receiveEnergy(Math.min(Integer.MAX_VALUE, this.toForge(amount)), simulate));
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.canReceive();
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.acceptor.canReceive();
        }

        public int toForge(double joules) {
            return (int)Math.round(joules * MekanismConfig.general.TO_FORGE);
        }

        public double fromForge(double forge) {
            return forge * MekanismConfig.general.FROM_FORGE;
        }
    }

    public static class TeslaAcceptor
    extends EnergyAcceptorWrapper {
        private ITeslaConsumer acceptor;

        public TeslaAcceptor(ITeslaConsumer teslaConsumer) {
            this.acceptor = teslaConsumer;
        }

        @Override
        public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
            return this.fromTesla(this.acceptor.givePower(this.toTesla(amount), false));
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.givePower(1L, true) > 0L;
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.canReceiveEnergy(side);
        }

        public long toTesla(double joules) {
            return Math.round(joules * MekanismConfig.general.TO_TESLA);
        }

        public double fromTesla(double tesla) {
            return tesla * MekanismConfig.general.FROM_TESLA;
        }
    }

    public static class IC2Acceptor
    extends EnergyAcceptorWrapper {
        private IEnergySink acceptor;

        public IC2Acceptor(IEnergySink ic2Acceptor) {
            this.acceptor = ic2Acceptor;
        }

        @Override
        public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
            double toTransfer = Math.min(Math.min(this.acceptor.getDemandedEnergy(), this.toEU(amount)), 2.147483647E9);
            double rejects = this.acceptor.injectEnergy(side, toTransfer, 0.0);
            return this.fromEU(toTransfer - rejects);
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.acceptsEnergyFrom(null, side);
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.acceptor.getDemandedEnergy() > 0.0;
        }

        public double toEU(double joules) {
            return joules * MekanismConfig.general.TO_IC2;
        }

        public double fromEU(double eu) {
            return eu * MekanismConfig.general.FROM_IC2;
        }
    }

    public static class RFAcceptor
    extends EnergyAcceptorWrapper {
        private IEnergyReceiver acceptor;

        public RFAcceptor(IEnergyReceiver rfAcceptor) {
            this.acceptor = rfAcceptor;
        }

        @Override
        public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
            return this.fromRF(this.acceptor.receiveEnergy(side, Math.min(Integer.MAX_VALUE, this.toRF(amount)), simulate));
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.canConnectEnergy(side);
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.acceptor.receiveEnergy(side, 1, true) > 0;
        }

        public int toRF(double joules) {
            return (int)Math.round(joules * MekanismConfig.general.TO_RF);
        }

        public double fromRF(int rf) {
            return (double)rf * MekanismConfig.general.FROM_RF;
        }
    }

    public static class MekanismAcceptor
    extends EnergyAcceptorWrapper {
        private IStrictEnergyAcceptor acceptor;

        public MekanismAcceptor(IStrictEnergyAcceptor mekAcceptor) {
            this.acceptor = mekAcceptor;
        }

        @Override
        public double acceptEnergy(EnumFacing side, double amount, boolean simulate) {
            return this.acceptor.acceptEnergy(side, amount, simulate);
        }

        @Override
        public boolean canReceiveEnergy(EnumFacing side) {
            return this.acceptor.canReceiveEnergy(side);
        }

        @Override
        public boolean needsEnergy(EnumFacing side) {
            return this.acceptor.acceptEnergy(side, 1.0, true) > 0.0;
        }
    }
}

