/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import java.util.HashMap;
import java.util.Map;
import mekanism.client.sound.FlamethrowerSound;
import mekanism.client.sound.GasMaskSound;
import mekanism.client.sound.IResettableSound;
import mekanism.client.sound.JetpackSound;
import mekanism.client.sound.PlayerSound;
import mekanism.common.ObfuscatedNames;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.ReflectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SoundHandler {
    public static Map<String, Map<String, IResettableSound>> soundMaps = new HashMap<String, Map<String, IResettableSound>>();
    public static Map<ISound, String> invPlayingSounds;
    public static Minecraft mc;

    public static boolean soundPlaying(EntityPlayer player, Channel channel) {
        String name = player.func_70005_c_();
        Map<String, IResettableSound> map = SoundHandler.getMap(name);
        IResettableSound sound = map.get(channel.getName());
        return sound != null && !sound.func_147667_k();
    }

    public static void addSound(EntityPlayer player, Channel channel, boolean replace) {
        String name = player.func_70005_c_();
        Map<String, IResettableSound> map = SoundHandler.getMap(name);
        IResettableSound sound = map.get(channel.getName());
        if (sound == null || replace) {
            PlayerSound newSound = channel.getNewSound(player);
            map.put(channel.getName(), newSound);
        }
    }

    public static boolean playSound(EntityPlayer player, Channel channel) {
        String name = player.func_70005_c_();
        Map<String, IResettableSound> map = SoundHandler.getMap(name);
        IResettableSound sound = map.get(channel.getName());
        if (sound != null) {
            if (SoundHandler.canRestartSound(sound)) {
                sound.reset();
                SoundHandler.playSound((ISound)sound);
            }
            return true;
        }
        return false;
    }

    public static Map<String, IResettableSound> getMap(String name) {
        Map<String, IResettableSound> map = soundMaps.get(name);
        if (map == null) {
            map = new HashMap<String, IResettableSound>();
            soundMaps.put(name, map);
        }
        return map;
    }

    public static SoundManager getSoundManager() {
        try {
            return (SoundManager)ReflectionUtils.getPrivateValue(mc.func_147118_V(), net.minecraft.client.audio.SoundHandler.class, ObfuscatedNames.SoundHandler_sndManager);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<ISound, String> getSoundMap() {
        if (invPlayingSounds == null) {
            try {
                invPlayingSounds = (Map)ReflectionUtils.getPrivateValue(SoundHandler.getSoundManager(), SoundManager.class, ObfuscatedNames.SoundManager_invPlayingSounds);
            }
            catch (Exception e) {
                invPlayingSounds = null;
            }
        }
        return invPlayingSounds;
    }

    public static boolean canRestartSound(ITickableSound sound) {
        return sound.func_147667_k() && !SoundHandler.getSoundMap().containsKey(sound);
    }

    public static void playSound(SoundEvent sound) {
        SoundHandler.playSound((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)sound, (float)MekanismConfig.client.baseSoundVolume));
    }

    public static void playSound(ISound sound) {
        mc.func_147118_V().func_147682_a(sound);
    }

    static {
        mc = Minecraft.func_71410_x();
    }

    public static enum Channel {
        JETPACK("jetpack", JetpackSound.class),
        GASMASK("gasMask", GasMaskSound.class),
        FLAMETHROWER("flamethrower", FlamethrowerSound.class);

        String channelName;
        Class<? extends PlayerSound> soundClass;

        private Channel(String name, Class<? extends PlayerSound> clazz) {
            this.channelName = name;
            this.soundClass = clazz;
        }

        public String getName() {
            return this.channelName;
        }

        public PlayerSound getNewSound(EntityPlayer player) {
            try {
                return this.soundClass.getDeclaredConstructor(EntityPlayer.class).newInstance(player);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

