/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine.chemical;

import java.util.List;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.machine.chemical.ChemicalWasherRecipeWrapper;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class ChemicalWasherRecipeCategory
extends BaseRecipeCategory {
    public IGuiHelper guiHelper;
    public IDrawable background;
    public IDrawable fluidOverlay;
    public WasherRecipe tempRecipe;
    public ITickTimer timer;

    public ChemicalWasherRecipeCategory(IGuiHelper helper) {
        super("mekanism:gui/nei/GuiChemicalWasher.png", "chemical_washer", "tile.MachineBlock2.ChemicalWasher.name", null);
        this.guiHelper = helper;
        this.timer = helper.createTickTimer(20, 20, false);
        this.xOffset = 3;
        this.yOffset = 3;
        this.background = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), this.xOffset, this.yOffset, 170, 70);
        this.fluidOverlay = this.guiHelper.createDrawable(new ResourceLocation(this.guiTexture), 176, 4, 16, 59);
    }

    @Override
    public void drawExtras(Minecraft minecraft) {
        super.drawExtras(minecraft);
        this.drawTexturedRect(61 - this.xOffset, 39 - this.yOffset, 176, 63, 55, 8);
        if (((GasInput)this.tempRecipe.getInput()).ingredient != null) {
            this.displayGauge(58, 27 - this.xOffset, 14 - this.yOffset, 176, 4, 58, null, ((GasInput)this.tempRecipe.getInput()).ingredient);
        }
        if (((GasOutput)this.tempRecipe.getOutput()).output != null) {
            this.displayGauge(58, 134 - this.xOffset, 14 - this.yOffset, 176, 4, 58, null, ((GasOutput)this.tempRecipe.getOutput()).output);
        }
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (recipeWrapper instanceof ChemicalWasherRecipeWrapper) {
            this.tempRecipe = ((ChemicalWasherRecipeWrapper)recipeWrapper).recipe;
        }
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        fluidStacks.init(0, true, 6 - this.xOffset, 5 - this.yOffset, 16, 58, 1000, false, this.fluidOverlay);
        fluidStacks.set(0, (List)ingredients.getInputs(FluidStack.class).get(0));
        fluidStacks.addTooltipCallback((ITooltipCallback)new ITooltipCallback<FluidStack>(){

            public void onTooltip(int slotIndex, boolean input, FluidStack ingredient, List<String> tooltip) {
                tooltip.remove(1);
            }
        });
    }
}

