/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.Arrays;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasTank;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiGauge;
import mekanism.common.Mekanism;
import mekanism.common.base.ITankManager;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.PacketDropperUse;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiGasGauge
extends GuiGauge<Gas> {
    IGasInfoHandler infoHandler;

    public GuiGasGauge(IGasInfoHandler handler, GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(type, gui, def, x, y);
        this.infoHandler = handler;
    }

    public static GuiGasGauge getDummy(GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        GuiGasGauge gauge = new GuiGasGauge(null, type, gui, def, x, y);
        gauge.dummy = true;
        return gauge;
    }

    @Override
    public TransmissionType getTransmission() {
        return TransmissionType.GAS;
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (xAxis >= this.xLocation + 1 && xAxis <= this.xLocation + this.width - 1 && yAxis >= this.yLocation + 1 && yAxis <= this.yLocation + this.height - 1) {
            int index;
            TileEntityContainerBlock tile;
            ItemStack stack = GuiGasGauge.mc.field_71439_g.field_71071_by.func_70445_o();
            if (this.guiObj instanceof GuiMekanism && stack != null && stack.func_77973_b() instanceof ItemGaugeDropper && (tile = ((GuiMekanism)this.guiObj).getTileEntity()) instanceof ITankManager && ((ITankManager)((Object)tile)).getTanks() != null && (index = Arrays.asList(((ITankManager)((Object)tile)).getTanks()).indexOf(this.infoHandler.getTank())) != -1) {
                if (button == 0 && Keyboard.isKeyDown((int)42)) {
                    button = 2;
                }
                Mekanism.packetHandler.sendToServer(new PacketDropperUse.DropperUseMessage(Coord4D.get(tile), button, index));
            }
        }
    }

    @Override
    public int getScaledLevel() {
        if (this.dummy) {
            return this.height - 2;
        }
        if (this.infoHandler.getTank().getGas() == null || this.infoHandler.getTank().getMaxGas() == 0) {
            return 0;
        }
        return this.infoHandler.getTank().getStored() * (this.height - 2) / this.infoHandler.getTank().getMaxGas();
    }

    @Override
    public TextureAtlasSprite getIcon() {
        if (this.dummy) {
            return ((Gas)this.dummyType).getSprite();
        }
        return this.infoHandler.getTank() != null && this.infoHandler.getTank().getGas() != null && this.infoHandler.getTank().getGas().getGas() != null ? this.infoHandler.getTank().getGas().getGas().getSprite() : null;
    }

    @Override
    public String getTooltipText() {
        if (this.dummy) {
            return ((Gas)this.dummyType).getLocalizedName();
        }
        return this.infoHandler.getTank().getGas() != null ? this.infoHandler.getTank().getGas().getGas().getLocalizedName() + ": " + this.infoHandler.getTank().getStored() : LangUtils.localize("gui.empty");
    }

    public static interface IGasInfoHandler {
        public GasTank getTank();
    }
}

