/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.common.blocks.world.taint.TaintHelper;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.entities.monster.tainted.EntityTaintCrawler;
import thaumcraft.common.entities.monster.tainted.EntityTaintSeedPrime;
import thaumcraft.common.lib.potions.PotionInfectiousVisExhaust;
import thaumcraft.common.lib.utils.RandomItemChooser;
import thaumcraft.common.world.aura.AuraHandler;

public class TaintEvents {
    static ArrayList<RandomItemChooser.Item> events = new ArrayList();

    protected static boolean taintEvent(World world, BlockPos pos) {
        List targets2;
        RandomItemChooser ric = new RandomItemChooser();
        TaintItem ei = (TaintItem)ric.chooseOnWeight(events);
        if (ei == null) {
            return false;
        }
        pos = pos.func_177982_a(world.field_73012_v.nextInt(16), 0, world.field_73012_v.nextInt(16));
        BlockPos p2 = world.func_175725_q(pos);
        if (world.field_73011_w.func_177495_o()) {
            p2 = new BlockPos(p2.func_177958_n(), 10, p2.func_177952_p());
            while (!world.func_175623_d(p2.func_177984_a()) && !world.func_175623_d(p2.func_177981_b(2))) {
                if (p2.func_177956_o() > world.func_72940_L()) {
                    return false;
                }
                p2 = p2.func_177984_a();
            }
        }
        if (!ei.nearTaintAllowed && TaintHelper.isNearTaintSeed(world, p2)) {
            return false;
        }
        if (AuraHandler.getFlux(world, p2) < (float)ei.cost) {
            return false;
        }
        boolean didit = false;
        switch (ei.event) {
            case 0: {
                if (p2.func_177956_o() + 5 >= world.func_72940_L()) break;
                EntityWisp wisp = new EntityWisp(world);
                wisp.func_70012_b(p2.func_177958_n(), p2.func_177956_o() + 5, p2.func_177952_p(), 0.0f, 0.0f);
                if (world.field_73012_v.nextInt(3) == 0) {
                    wisp.setType(Aspect.FLUX.getTag());
                }
                if (!world.func_72838_d((Entity)wisp)) break;
                didit = true;
                break;
            }
            case 1: {
                if (p2.func_177956_o() + 1 >= world.func_72940_L()) break;
                EntityTaintCrawler crawler = new EntityTaintCrawler(world);
                crawler.func_70012_b(p2.func_177958_n(), p2.func_177956_o() + 1, p2.func_177952_p(), 0.0f, 0.0f);
                if (!world.func_72838_d((Entity)crawler)) break;
                didit = true;
                break;
            }
            case 2: {
                if (p2.func_177956_o() + 1 >= world.func_72940_L()) break;
                EntityTaintSeedPrime seed = new EntityTaintSeedPrime(world);
                seed.func_70012_b(p2.func_177958_n(), p2.func_177956_o() + 1, p2.func_177952_p(), world.field_73012_v.nextInt(360), 0.0f);
                if (!world.func_72838_d((Entity)seed)) break;
                didit = true;
                break;
            }
            case 3: {
                targets2 = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)p2.func_177958_n(), (double)p2.func_177956_o(), (double)p2.func_177952_p(), (double)(p2.func_177958_n() + 1), (double)(p2.func_177956_o() + 1), (double)(p2.func_177952_p() + 1)).func_72314_b(16.0, 16.0, 16.0));
                if (targets2 == null || targets2.size() <= 0) break;
                for (EntityLivingBase target : targets2) {
                    didit = true;
                    if (target instanceof EntityPlayer) {
                        ((EntityPlayer)target).func_145747_a((ITextComponent)new TextComponentString("\u00a75\u00a7o" + I18n.func_74838_a((String)"tc.fluxevent.2")));
                    }
                    PotionEffect pe = new PotionEffect((Potion)PotionInfectiousVisExhaust.instance, 3000, 2);
                    pe.getCurativeItems().clear();
                    try {
                        target.func_70690_d(pe);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
        }
        if (didit) {
            AuraHandler.drainFlux(world, p2, ei.cost, false);
            targets2 = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)p2.func_177958_n(), (double)p2.func_177956_o(), (double)p2.func_177952_p(), (double)(p2.func_177958_n() + 1), (double)(p2.func_177956_o() + 1), (double)(p2.func_177952_p() + 1)).func_72314_b(32.0, 32.0, 32.0));
            if (targets2 != null && targets2.size() > 0) {
                for (EntityLivingBase target : targets2) {
                    IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)target);
                    if (knowledge.isResearchKnown("f_toomuchflux")) continue;
                    target.func_145747_a((ITextComponent)new TextComponentString("\u00a75\u00a7o" + I18n.func_74838_a((String)"tc.fluxevent.3")));
                    ThaumcraftApi.internalMethods.completeResearch((EntityPlayer)target, "f_toomuchflux");
                }
            }
        }
        return true;
    }

    private static BlockPos findSpotToStrike(final World world, BlockPos pos) {
        BlockPos blockpos1 = world.func_175725_q(pos);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockpos1, new BlockPos(blockpos1.func_177958_n(), world.func_72800_K(), blockpos1.func_177952_p())).func_72314_b(4.0, 4.0, 4.0);
        List list = world.func_175647_a(EntityLivingBase.class, axisalignedbb, new Predicate(){

            public boolean applyLiving(EntityLivingBase living) {
                return living != null && living.func_70089_S() && world.func_175678_i(living.func_180425_c());
            }

            public boolean apply(Object p_apply_1_) {
                return this.applyLiving((EntityLivingBase)p_apply_1_);
            }
        });
        return !list.isEmpty() ? ((EntityLivingBase)list.get(world.field_73012_v.nextInt(list.size()))).func_180425_c() : blockpos1;
    }

    static {
        events.add(new TaintItem(0, 1, 5, true));
        events.add(new TaintItem(1, 5, 10, true));
        events.add(new TaintItem(2, 15, 25, false));
        events.add(new TaintItem(3, 5, 15, false));
    }

    static class TaintItem
    implements RandomItemChooser.Item {
        int weight;
        int event;
        int cost;
        boolean nearTaintAllowed;

        protected TaintItem(int event, int weight, int cost, boolean nearTaintAllowed) {
            this.weight = weight;
            this.event = event;
            this.cost = cost;
            this.nearTaintAllowed = nearTaintAllowed;
        }

        @Override
        public double getWeight() {
            return this.weight;
        }
    }
}

