/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.entity.Entity;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusMedium;
import thaumcraft.api.casters.FocusNode;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.common.entities.projectile.EntityFocusProjectile;

public class FocusMediumProjectile
extends FocusMedium {
    @Override
    public String getResearch() {
        return "FOCUSPROJECTILE";
    }

    @Override
    public String getKey() {
        return "thaumcraft.PROJECTILE";
    }

    @Override
    public int getComplexity() {
        return 4 + (this.getSettingValue("speed") - 1) / 2;
    }

    @Override
    public FocusNode.EnumSupplyType[] willSupply() {
        return new FocusNode.EnumSupplyType[]{FocusNode.EnumSupplyType.TARGET, FocusNode.EnumSupplyType.TRAJECTORY};
    }

    @Override
    public boolean execute(Trajectory trajectory) {
        float speed = (float)this.getSettingValue("speed") / 3.0f;
        EntityFocusProjectile projectile = new EntityFocusProjectile(this.getRemainingPackage(), speed, trajectory);
        return this.getPackage().getCaster().field_70170_p.func_72838_d((Entity)projectile);
    }

    @Override
    public boolean hasIntermediary() {
        return true;
    }

    @Override
    public NodeSetting[] createSettings() {
        return new NodeSetting[]{new NodeSetting("speed", "focus.projectile.speed", new NodeSetting.NodeSettingIntRange(1, 5))};
    }

    @Override
    public Aspect getAspect() {
        return Aspect.MOTION;
    }
}

