/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.casters.foci;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.tiles.misc.TileHole;

public class FocusEffectRift
extends FocusEffect {
    @Override
    public String getResearch() {
        return "FOCUSRIFT";
    }

    @Override
    public String getKey() {
        return "thaumcraft.RIFT";
    }

    @Override
    public Aspect getAspect() {
        return Aspect.ELDRITCH;
    }

    @Override
    public int getComplexity() {
        return 3 + this.getSettingValue("duration") / 2 + this.getSettingValue("depth") / 4;
    }

    @Override
    public boolean execute(RayTraceResult target, Trajectory trajectory, float finalPower, int num) {
        if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState bi;
            if (this.getPackage().world.field_73011_w.getDimension() == Config.dimensionOuterId) {
                this.getPackage().world.func_184148_a(null, (double)target.func_178782_a().func_177958_n() + 0.5, (double)target.func_178782_a().func_177956_o() + 0.5, (double)target.func_178782_a().func_177952_p() + 0.5, SoundsTC.wandfail, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return false;
            }
            float maxdis = (float)this.getSettingValue("depth") * finalPower;
            int dur = 20 * this.getSettingValue("duration");
            int distance = 0;
            BlockPos pos = new BlockPos((Vec3i)target.func_178782_a());
            distance = 0;
            while ((float)distance < maxdis && !BlockUtils.isPortableHoleBlackListed(bi = this.getPackage().world.func_180495_p(pos)) && bi.func_177230_c() != Blocks.field_150357_h && bi.func_177230_c() != BlocksTC.hole && !bi.func_177230_c().isAir(bi, (IBlockAccess)this.getPackage().world, pos) && bi.func_185887_b(this.getPackage().world, pos) != -1.0f) {
                pos = pos.func_177972_a(target.field_178784_b.func_176734_d());
                ++distance;
            }
            FocusEffectRift.createHole(this.getPackage().world, target.func_178782_a(), target.field_178784_b, (byte)Math.round(distance + 1), dur);
            return true;
        }
        return false;
    }

    public static boolean createHole(World world, BlockPos pos, EnumFacing side, byte count, int max) {
        IBlockState bs = world.func_180495_p(pos);
        if (!(world.field_72995_K || world.func_175625_s(pos) != null || BlockUtils.isPortableHoleBlackListed(bs) || bs.func_177230_c() == Blocks.field_150357_h || bs.func_177230_c() == BlocksTC.hole || !bs.func_177230_c().isAir(bs, (IBlockAccess)world, pos) && bs.func_177230_c().func_176196_c(world, pos) || bs.func_185887_b(world, pos) == -1.0f)) {
            if (world.func_175656_a(pos, BlocksTC.hole.func_176223_P())) {
                TileHole ts = (TileHole)world.func_175625_s(pos);
                ts.oldblock = bs;
                ts.countdownmax = (short)max;
                ts.count = count;
                ts.direction = side;
                ts.func_70296_d();
            }
            return true;
        }
        return false;
    }

    @Override
    public NodeSetting[] createSettings() {
        int[] depth = new int[]{8, 16, 24, 32};
        String[] depthDesc = new String[]{"8", "16", "24", "32"};
        return new NodeSetting[]{new NodeSetting("depth", "focus.rift.depth", new NodeSetting.NodeSettingIntList(depth, depthDesc)), new NodeSetting("duration", "focus.common.duration", new NodeSetting.NodeSettingIntRange(2, 10))};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        FXGeneric fb = new FXGeneric(world, posX, posY, posZ, motionX, motionY, motionZ);
        fb.func_187114_a(16 + world.field_73012_v.nextInt(16));
        fb.setParticles(384 + world.field_73012_v.nextInt(16), 1, 1);
        fb.setSlowDown(0.75);
        fb.setAlphaF(1.0f, 0.0f);
        fb.setScale((float)((double)0.7f + world.field_73012_v.nextGaussian() * (double)0.3f));
        fb.func_70538_b(0.25f, 0.25f, 1.0f);
        fb.setRandomMovementScale(0.01f, 0.01f, 0.01f);
        ParticleEngine.addEffectWithDelay(world, fb, 0);
    }

    @Override
    public void onCast(Entity caster) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.2f, 0.7f);
    }
}

