/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.projectile;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.lib.events.ServerEvents;
import thaumcraft.common.lib.utils.Utils;

public class EntityFocusProjectile
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    FocusPackage focusPackage;
    boolean noTouchy = false;
    boolean firstParticle = false;
    public float lastRenderTick = 0.0f;
    FocusEffect[] effects = null;

    public EntityFocusProjectile(World par1World) {
        super(par1World);
        this.func_70105_a(0.15f, 0.15f);
    }

    public EntityFocusProjectile(FocusPackage pack, float speed, Trajectory trajectory) {
        super(pack.world, pack.getCaster());
        this.focusPackage = pack;
        this.func_70107_b(trajectory.source.field_72450_a + trajectory.direction.field_72450_a / 5.0, trajectory.source.field_72448_b + trajectory.direction.field_72448_b / 5.0, trajectory.source.field_72449_c + trajectory.direction.field_72449_c / 5.0);
        this.func_70186_c(trajectory.direction.field_72450_a, trajectory.direction.field_72448_b, trajectory.direction.field_72449_c, speed, 0.0f);
        this.func_70105_a(0.15f, 0.15f);
        this.field_184539_c = pack.getCaster();
    }

    protected float func_70185_h() {
        return 0.01f;
    }

    public void writeSpawnData(ByteBuf data) {
        Utils.writeNBTTagCompoundToBuffer(data, this.focusPackage.serialize());
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.focusPackage = new FocusPackage();
            this.focusPackage.deserialize(Utils.readNBTTagCompoundFromBuffer(data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74782_a("pack", (NBTBase)this.focusPackage.serialize());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        try {
            this.focusPackage = new FocusPackage();
            this.focusPackage.deserialize(nbt.func_74775_l("pack"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_70184_a(final RayTraceResult mop) {
        if (mop != null && this.func_85052_h() != null) {
            if (mop.field_72308_g != null) {
                mop.field_72307_f = this.func_174791_d();
            }
            final Vec3d pv = new Vec3d(this.field_70169_q, this.field_70167_r, this.field_70166_s);
            final Vec3d vf = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            ServerEvents.addRunnableServer(this.func_130014_f_(), new Runnable(){

                @Override
                public void run() {
                    FocusEngine.runFocusPackage(EntityFocusProjectile.this.focusPackage, new Trajectory[]{new Trajectory(pv, vf.func_72432_b())}, new RayTraceResult[]{mop});
                }
            }, 0);
        }
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 1200 || !this.field_70170_p.field_72995_K && this.func_85052_h() == null) {
            this.func_70106_y();
        }
        this.firstParticle = true;
    }

    public void renderParticle(float coeff) {
        this.lastRenderTick = coeff;
        if (this.effects == null) {
            this.effects = this.focusPackage.getFocusEffects();
        }
        if (this.effects != null && this.effects.length > 0) {
            FocusEffect eff = this.effects[this.field_70146_Z.nextInt(this.effects.length)];
            float scale = 1.0f;
            Color c1 = new Color(FocusEngine.getElementColor(eff.getKey()));
            FXDispatcher.INSTANCE.drawFireMote((float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)coeff), (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)coeff) + this.field_70131_O / 2.0f, (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)coeff), 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f) * scale, 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f) * scale, 0.0125f * (this.field_70146_Z.nextFloat() - 0.5f) * scale, (float)c1.getRed() / 255.0f, (float)c1.getGreen() / 255.0f, (float)c1.getBlue() / 255.0f, 0.5f, 4.0f * scale);
            if (this.firstParticle) {
                this.firstParticle = false;
                eff.renderParticleFX(this.field_70170_p, this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)coeff + this.field_70170_p.field_73012_v.nextGaussian() * (double)0.1f, this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)coeff + (double)(this.field_70131_O / 2.0f) + this.field_70170_p.field_73012_v.nextGaussian() * (double)0.1f, this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)coeff + this.field_70170_p.field_73012_v.nextGaussian() * (double)0.1f, this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f, this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f, this.field_70170_p.field_73012_v.nextGaussian() * (double)0.01f);
            }
        }
    }
}

