/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.tasks;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.common.entities.construct.golem.EntityThaumcraftGolem;
import thaumcraft.common.entities.construct.golem.seals.SealHandler;

public class TaskHandler {
    static final int TASK_LIMIT = 1000;
    public static ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, Task>> tasks = new ConcurrentHashMap();

    public static void addTask(int dim, Task ticket) {
        ConcurrentHashMap<Integer, Task> dc;
        if (!tasks.containsKey(dim)) {
            tasks.put(dim, new ConcurrentHashMap());
        }
        if ((dc = tasks.get(dim)).size() > 1000) {
            try {
                Iterator<Task> i = dc.values().iterator();
                if (i.hasNext()) {
                    i.next();
                    i.remove();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        dc.put(ticket.getId(), ticket);
    }

    public static Task getTask(int dim, int id) {
        return TaskHandler.getTasks(dim).get(id);
    }

    public static ConcurrentHashMap<Integer, Task> getTasks(int dim) {
        if (!tasks.containsKey(dim)) {
            tasks.put(dim, new ConcurrentHashMap());
        }
        return tasks.get(dim);
    }

    public static ArrayList<Task> getBlockTasksSorted(int dim, UUID uuid, Entity golem) {
        ConcurrentHashMap<Integer, Task> tickets = TaskHandler.getTasks(dim);
        ArrayList<Task> out = new ArrayList<Task>();
        block0: for (Task ticket : tickets.values()) {
            if (ticket.isReserved() || ticket.getType() != 0 || uuid != null && ticket.getGolemUUID() != null && !uuid.equals(ticket.getGolemUUID())) continue;
            if (out.size() == 0) {
                out.add(ticket);
                continue;
            }
            double d = ticket.getPos().func_177957_d(golem.field_70165_t, golem.field_70163_u, golem.field_70161_v);
            d -= (double)(ticket.getPriority() * 256);
            for (int a = 0; a < out.size(); ++a) {
                double d1 = out.get(a).getPos().func_177957_d(golem.field_70165_t, golem.field_70163_u, golem.field_70161_v);
                if (!(d < (d1 -= (double)(out.get(a).getPriority() * 256)))) continue;
                out.add(a, ticket);
                continue block0;
            }
            out.add(ticket);
        }
        return out;
    }

    public static ArrayList<Task> getEntityTasksSorted(int dim, UUID uuid, Entity golem) {
        ConcurrentHashMap<Integer, Task> tickets = TaskHandler.getTasks(dim);
        ArrayList<Task> out = new ArrayList<Task>();
        block0: for (Task ticket : tickets.values()) {
            if (ticket.isReserved() || ticket.getType() != 1 || uuid != null && ticket.getGolemUUID() != null && !uuid.equals(ticket.getGolemUUID())) continue;
            if (out.size() == 0) {
                out.add(ticket);
                continue;
            }
            double d = ticket.getPos().func_177957_d(golem.field_70165_t, golem.field_70163_u, golem.field_70161_v);
            d -= (double)(ticket.getPriority() * 256);
            for (int a = 0; a < out.size(); ++a) {
                double d1 = out.get(a).getPos().func_177957_d(golem.field_70165_t, golem.field_70163_u, golem.field_70161_v);
                if (!(d < (d1 -= (double)(out.get(a).getPriority() * 256)))) continue;
                out.add(a, ticket);
                continue block0;
            }
            out.add(ticket);
        }
        return out;
    }

    public static void completeTask(Task task, EntityThaumcraftGolem golem) {
        if (task.isCompleted() || task.isSuspended()) {
            return;
        }
        ISealEntity se = SealHandler.getSealEntity(golem.field_70170_p.field_73011_w.getDimension(), task.getSealPos());
        if (se != null) {
            task.setCompletion(se.getSeal().onTaskCompletion(golem.field_70170_p, golem, task));
        } else {
            task.setCompletion(true);
        }
    }

    public static void clearSuspendedOrExpiredTasks(World world) {
        ConcurrentHashMap<Integer, Task> tickets = TaskHandler.getTasks(world.field_73011_w.getDimension());
        ConcurrentHashMap<Integer, Task> temp = new ConcurrentHashMap<Integer, Task>();
        for (Task ticket : tickets.values()) {
            if (!ticket.isSuspended() && ticket.getLifespan() > 0L) {
                ticket.setLifespan((short)(ticket.getLifespan() - 1L));
                temp.put(ticket.getId(), ticket);
                continue;
            }
            ISealEntity sEnt = SealHandler.getSealEntity(world.field_73011_w.getDimension(), ticket.getSealPos());
            if (sEnt == null) continue;
            sEnt.getSeal().onTaskSuspension(world, ticket);
        }
        tasks.put(world.field_73011_w.getDimension(), temp);
    }
}

