/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power.forge;

import crazypants.enderio.power.IInternalPoweredTile;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class InternalPoweredTileWrapper
implements IEnergyStorage {
    private final IInternalPoweredTile tile;
    protected final EnumFacing from;

    public InternalPoweredTileWrapper(IInternalPoweredTile tile, EnumFacing from) {
        this.tile = tile;
        this.from = from;
    }

    public int getEnergyStored() {
        return this.tile.getEnergyStored(this.from);
    }

    public int getMaxEnergyStored() {
        return this.tile.getMaxEnergyStored(this.from);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }

    public static class PoweredTileCapabilityProvider
    implements ICapabilityProvider {
        private final IInternalPoweredTile tile;

        public PoweredTileCapabilityProvider(IInternalPoweredTile tile) {
            this.tile = tile;
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)new InternalPoweredTileWrapper(this.tile, facing);
            }
            return null;
        }
    }
}

