/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.network;

import crazypants.enderio.Log;
import crazypants.enderio.network.IRemoteExec;
import crazypants.enderio.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class GuiPacket
implements IMessage {
    private static final DataType[][] PATTERN = new DataType[][]{new DataType[0], {DataType.INT}, {DataType.STRING}};
    private int guiID;
    private int msgID;
    private int pattern;
    private int[] ints;
    private long[] longs;
    private String[] strings;

    public static void send(IRemoteExec gui, int msgID) {
        GuiPacket p = new GuiPacket(gui, msgID, 0, null);
        p.send();
    }

    public static void send(IRemoteExec gui, int msgID, int data) {
        GuiPacket p = new GuiPacket(gui, msgID, 1, new int[]{data});
        p.send();
    }

    public static void send(IRemoteExec gui, int msgID, Enum<?> data) {
        GuiPacket p = new GuiPacket(gui, msgID, 1, new int[]{data.ordinal()});
        p.send();
    }

    public static void send(IRemoteExec gui, int msgID, boolean data) {
        GuiPacket p = new GuiPacket(gui, msgID, 1, new int[]{data ? 1 : 0});
        p.send();
    }

    public static void send(IRemoteExec gui, int msgID, String data) {
        GuiPacket p = new GuiPacket(gui, msgID, 2, null, null, new String[]{data});
        p.send();
    }

    private GuiPacket(IRemoteExec gui, int msgID, int pattern, int[] ints, long[] longs, String[] strings) {
        this.guiID = gui.getGuiID();
        this.msgID = msgID;
        this.pattern = pattern;
        this.ints = ints;
        this.longs = longs;
        this.strings = strings;
    }

    private GuiPacket(IRemoteExec gui, int msgID, int pattern, int[] ints, long[] longs) {
        this(gui, msgID, pattern, ints, longs, null);
    }

    private GuiPacket(IRemoteExec gui, int msgID, int pattern, int[] ints) {
        this(gui, msgID, pattern, ints, null, null);
    }

    public GuiPacket() {
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.guiID);
        buf.writeShort(this.msgID);
        buf.writeShort(this.pattern);
        int idx = 0;
        block5: for (DataType dt : PATTERN[this.pattern]) {
            switch (dt) {
                case INT: {
                    buf.writeInt(this.ints[idx++]);
                    continue block5;
                }
                case LONG: {
                    buf.writeLong(this.longs[idx++]);
                    continue block5;
                }
                case STRING: {
                    buf.writeBoolean(this.strings[idx] != null);
                    if (this.strings[idx] != null) {
                        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.strings[idx]);
                    }
                    ++idx;
                }
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.guiID = buf.readShort();
        this.msgID = buf.readShort();
        this.pattern = buf.readShort();
        if (this.pattern < 0 || this.pattern >= PATTERN.length) {
            Log.warn("Invalid network packet received (" + this.guiID + "/" + this.msgID + "/" + this.pattern + "): p invalid");
            return;
        }
        int idx = 0;
        block5: for (DataType dt : PATTERN[this.pattern]) {
            switch (dt) {
                case INT: {
                    if (this.ints == null) {
                        this.ints = new int[PATTERN[this.pattern].length];
                    }
                    this.ints[idx++] = buf.readInt();
                    continue block5;
                }
                case LONG: {
                    if (this.longs == null) {
                        this.longs = new long[PATTERN[this.pattern].length];
                    }
                    this.longs[idx++] = buf.readLong();
                    continue block5;
                }
                case STRING: {
                    if (this.strings == null) {
                        this.strings = new String[PATTERN[this.pattern].length];
                    }
                    if (buf.readBoolean()) {
                        this.strings[idx] = ByteBufUtils.readUTF8String((ByteBuf)buf);
                    }
                    ++idx;
                }
            }
        }
    }

    private boolean checkAccess(int idx, DataType type) {
        if (idx >= PATTERN[this.pattern].length) {
            Log.warn("Invalid network packet received (" + this.guiID + "/" + this.msgID + "/" + this.pattern + "): idx" + idx + " high");
            return false;
        }
        if (PATTERN[this.pattern][idx] != type) {
            Log.warn("Invalid network packet received (" + this.guiID + "/" + this.msgID + "/" + this.pattern + "): idx" + idx + " not " + (Object)((Object)type));
            return false;
        }
        if (type == DataType.INT && this.ints == null || type == DataType.LONG && this.longs == null || type == DataType.STRING && this.strings == null) {
            Log.warn("Invalid network packet received (" + this.guiID + "/" + this.msgID + "/" + this.pattern + "): idx" + idx + " no " + (Object)((Object)type) + " data");
            return false;
        }
        return true;
    }

    private void send() {
        PacketHandler.INSTANCE.sendToServer((IMessage)this);
    }

    public int getInt(int idx) {
        return this.checkAccess(idx, DataType.INT) ? this.ints[idx] : 0;
    }

    public <E extends Enum<?>> E getEnum(int idx, Class<E> clazz) {
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        return (E)enumConstants[MathHelper.func_76125_a((int)this.getInt(idx), (int)0, (int)(enumConstants.length - 1))];
    }

    public boolean getBoolean(int idx) {
        return this.getInt(idx) != 0;
    }

    public long getLong(int idx) {
        return this.checkAccess(idx, DataType.LONG) ? this.longs[idx] : 0L;
    }

    public BlockPos getBlockPos(int idx) {
        return BlockPos.func_177969_a((long)this.getLong(idx));
    }

    public String getString(int idx) {
        return this.checkAccess(idx, DataType.STRING) ? this.strings[idx] : null;
    }

    public static class Handler
    implements IMessageHandler<GuiPacket, IMessage> {
        public IMessage onMessage(GuiPacket message, MessageContext ctx) {
            Container openContainer = ctx.getServerHandler().field_147369_b.field_71070_bA;
            if (openContainer instanceof IRemoteExec.IContainer && ((IRemoteExec.IContainer)openContainer).getGuiID() == message.guiID && message.guiID >= 0) {
                ((IRemoteExec.IContainer)openContainer).networkExec(message.msgID, message);
                Log.debug("Exec ok (" + message.guiID + "/" + message.msgID + "/" + message.pattern + "): cont=" + openContainer);
            } else {
                Log.debug("Invalid network packet received (" + message.guiID + "/" + message.msgID + "/" + message.pattern + "): cont=" + openContainer + " id=" + (openContainer instanceof IRemoteExec.IContainer ? Integer.valueOf(((IRemoteExec.IContainer)openContainer).getGuiID()) : "n/a"));
            }
            return null;
        }
    }

    private static enum DataType {
        INT,
        LONG,
        STRING;

    }
}

