/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.spawner;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.google.common.collect.Lists;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.spawner.ContainerPoweredSpawner;
import crazypants.enderio.machine.spawner.TilePoweredSpawner;
import crazypants.enderio.network.GuiPacket;
import crazypants.enderio.network.IRemoteExec;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;

public class GuiPoweredSpawner
extends GuiPoweredMachineBase<TilePoweredSpawner> {
    private final MultiIconButton modeB = MultiIconButton.createRightArrowButton((IGuiScreen)this, (int)8888, (int)115, (int)10);
    private final Rectangle progressTooltipRect;
    private boolean wasSpawnMode;
    private String header;
    private ToggleButton showRangeB;

    public GuiPoweredSpawner(InventoryPlayer par1InventoryPlayer, TilePoweredSpawner te) {
        super(te, (Container)new ContainerPoweredSpawner(par1InventoryPlayer, te), "poweredSpawner");
        this.modeB.setSize(10, 16);
        this.addProgressTooltip(80, 34, 14, 14);
        this.progressTooltipRect = ((GuiToolTip)this.progressTooltips.get(0)).getBounds();
        this.updateSpawnMode(te.isSpawnMode());
        int x = this.getXSize() - 5 - 16;
        this.showRangeB = new ToggleButton((IGuiScreen)this, -1, x, 44, (IWidgetIcon)IconEIO.SHOW_RANGE, (IWidgetIcon)IconEIO.HIDE_RANGE);
        this.showRangeB.setSize(16, 16);
        this.addToolTip(new GuiToolTip(this.showRangeB.getBounds(), new String[]{"null"}){

            public List<String> getToolTipText() {
                return Lists.newArrayList((Object[])new String[]{EnderIO.lang.localize(GuiPoweredSpawner.this.showRangeB.isSelected() ? "gui.spawnGurad.hideRange" : "gui.spawnGurad.showRange")});
            }
        });
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.modeB.onGuiInit();
        this.showRangeB.onGuiInit();
        this.showRangeB.setSelected(((TilePoweredSpawner)this.getTileEntity()).isShowingRange());
    }

    protected void func_146284_a(GuiButton par1GuiButton) throws IOException {
        if (par1GuiButton == this.modeB) {
            ((TilePoweredSpawner)this.getTileEntity()).setSpawnMode(!((TilePoweredSpawner)this.getTileEntity()).isSpawnMode());
            GuiPacket.send((IRemoteExec)this, 0, ((TilePoweredSpawner)this.getTileEntity()).isSpawnMode());
        } else if (par1GuiButton == this.showRangeB) {
            ((TilePoweredSpawner)this.getTileEntity()).setShowRange(this.showRangeB.isSelected());
        } else {
            super.func_146284_a(par1GuiButton);
        }
    }

    private void updateSpawnMode(boolean spawnMode) {
        this.wasSpawnMode = spawnMode;
        ((ContainerPoweredSpawner)this.field_147002_h).setSlotVisibility(!spawnMode);
        if (spawnMode) {
            this.getGhostSlots().clear();
            this.header = EnderIO.lang.localize("gui.machine.poweredspawner.spawn");
            this.progressTooltipRect.x = 80;
            this.progressTooltipRect.y = 34;
            this.progressTooltipRect.width = 14;
            this.progressTooltipRect.height = 14;
        } else {
            ((ContainerPoweredSpawner)this.field_147002_h).createGhostSlots(this.getGhostSlots());
            this.header = EnderIO.lang.localize("gui.machine.poweredspawner.capture");
            this.progressTooltipRect.x = 52;
            this.progressTooltipRect.y = 40;
            this.progressTooltipRect.width = 72;
            this.progressTooltipRect.height = 21;
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        super.func_146976_a(par1, par2, par3);
        TilePoweredSpawner spawner = (TilePoweredSpawner)this.getTileEntity();
        boolean spawnMode = spawner.isSpawnMode();
        if (spawnMode != this.wasSpawnMode) {
            this.updateSpawnMode(spawnMode);
        }
        FontRenderer fr = this.getFontRenderer();
        int x = sx + this.field_146999_f / 2 - fr.func_78256_a(this.header) / 2;
        int y = sy + fr.field_78288_b + 6;
        fr.func_175063_a(this.header, (float)x, (float)y, ColorUtil.getRGB((Color)Color.WHITE));
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        if (spawnMode) {
            this.func_73729_b(sx + 80, sy + 34, 207, 0, 17, 15);
            if (this.shouldRenderProgress()) {
                int scaled = this.getProgressScaled(14) + 1;
                this.func_73729_b(sx + 81, sy + 34 + 14 - scaled, 176, 14 - scaled, 14, scaled);
            }
        } else {
            this.func_73729_b(sx + 52, sy + 40, 52, 170, 72, 21);
            if (this.shouldRenderProgress()) {
                int scaled = this.getProgressScaled(24);
                this.func_73729_b(sx + 76, sy + 43, 176, 14, scaled + 1, 16);
            }
        }
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }
}

