/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeOutput {
    private final FluidStack outputFluid;
    private final ItemStack output;
    private final float chance;
    private float exp;

    public RecipeOutput(Block output) {
        this(new ItemStack(output), 1.0f);
    }

    public RecipeOutput(Block output, float chance) {
        this(new ItemStack(output), chance);
    }

    public RecipeOutput(Item output, float chance) {
        this(new ItemStack(output), chance);
    }

    public RecipeOutput(Item output) {
        this(new ItemStack(output), 1.0f);
    }

    public RecipeOutput(ItemStack output) {
        this(output, 1.0f);
    }

    public RecipeOutput(ItemStack output, float chance) {
        this(output, chance, 0.0f);
    }

    public RecipeOutput(ItemStack output, float chance, float exp) {
        this.output = output.func_77946_l();
        this.chance = chance;
        this.exp = exp;
        this.outputFluid = null;
    }

    public RecipeOutput(FluidStack output) {
        this.outputFluid = output;
        this.output = null;
        this.chance = 1.0f;
        this.exp = 0.0f;
    }

    public float getChance() {
        return this.chance;
    }

    public float getExperiance() {
        return this.exp;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public FluidStack getFluidOutput() {
        return this.outputFluid;
    }

    public boolean isFluid() {
        return this.outputFluid != null;
    }

    public boolean isValid() {
        if (this.isFluid()) {
            return this.outputFluid.getFluid() != null;
        }
        return this.output != null && this.output.func_77973_b() != null;
    }
}

