/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter.recipe;

import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;

public abstract class AbstractPainterTemplate<T>
implements IMachineRecipe {
    public AbstractPainterTemplate() {
        this.registerTargetsWithTooltipProvider();
    }

    protected abstract void registerTargetsWithTooltipProvider();

    public abstract boolean isValidTarget(ItemStack var1);

    public abstract IMachineRecipe.ResultStack[] getCompletedResult(ItemStack var1, ItemStack var2);

    public abstract boolean isRecipe(ItemStack var1, ItemStack var2);

    public abstract boolean isPartialRecipe(ItemStack var1, ItemStack var2);

    @Override
    public int getEnergyRequired(MachineRecipeInput ... inputs) {
        return Config.painterEnergyPerTaskRF;
    }

    @Override
    public RecipeBonusType getBonusType(MachineRecipeInput ... inputs) {
        return RecipeBonusType.NONE;
    }

    public ItemStack getTarget(MachineRecipeInput ... inputs) {
        return MachineRecipeInput.getInputForSlot(0, inputs);
    }

    public ItemStack getPaintSource(MachineRecipeInput ... inputs) {
        return MachineRecipeInput.getInputForSlot(1, inputs);
    }

    @Override
    public final boolean isRecipe(MachineRecipeInput ... inputs) {
        return this.isRecipe(this.getPaintSource(inputs), this.getTarget(inputs));
    }

    @Override
    public final IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
        return this.getCompletedResult(this.getPaintSource(inputs), this.getTarget(inputs));
    }

    @Override
    public String getMachineName() {
        return ModObject.blockPainter.getUnlocalisedName();
    }

    @Override
    public String getUid() {
        return this.getClass().getCanonicalName() + "@" + Integer.toHexString(this.hashCode());
    }

    public int getQuantityConsumed(MachineRecipeInput input) {
        return input.slotNumber == 0 ? 1 : 0;
    }

    @Override
    public List<MachineRecipeInput> getQuantitiesConsumed(MachineRecipeInput[] inputs) {
        MachineRecipeInput consume = null;
        for (MachineRecipeInput input : inputs) {
            if (input == null || input.slotNumber != 0 || input.item == null) continue;
            ItemStack consumed = input.item.func_77946_l();
            consumed.field_77994_a = 1;
            consume = new MachineRecipeInput(input.slotNumber, consumed);
        }
        if (consume != null) {
            return Collections.singletonList(consume);
        }
        return null;
    }

    @Override
    public float getExperienceForOutput(ItemStack output) {
        return 0.0f;
    }

    @Override
    public abstract boolean isValidInput(MachineRecipeInput var1);
}

