/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.xp;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.SmartTankFluidHandler;
import crazypants.enderio.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.machine.AbstractInventoryMachineEntity;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.XpUtil;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileExperienceObelisk
extends AbstractInventoryMachineEntity
implements IHaveExperience,
ITankAccess {
    @Store
    private ExperienceContainer xpCont = new ExperienceContainer(XpUtil.getExperienceForLevel(Config.xpObeliskMaxXpLevel));
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileExperienceObelisk() {
        super(new SlotDefinition(0, 0, 0));
        this.xpCont.setTileEntity((TileEntity)this);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockExperienceObelisk.getUnlocalisedName();
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (this.xpCont.isDirty()) {
            PacketHandler.sendToAllAround((IMessage)new PacketExperianceContainer((TileEntity)this), (TileEntity)this);
            this.xpCont.setDirty(false);
        }
        return false;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        boolean res = super.doPull(dir);
        if (dir != null && this.xpCont.getFluidAmount() < this.xpCont.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.xpCont, (int)Config.fluidConduitMaxIoRate) > 0) {
            this.setTanksDirty();
        }
        return res;
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        boolean res = super.doPush(dir);
        if (dir != null && this.xpCont.getFluidAmount() > 0 && FluidWrapper.transfer((FluidTank)this.xpCont, (IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (int)Config.fluidConduitMaxIoRate) > 0) {
            this.setTanksDirty();
        }
        return res;
    }

    @Override
    public ExperienceContainer getContainer() {
        return this.xpCont;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.xpCont;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCont};
    }

    public void setTanksDirty() {
        this.xpCont.setDirty(true);
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.xpCont});
        }
        return this.smartTankFluidHandler;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facingIn) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.getSmartTankFluidHandler().get(facingIn);
        }
        return super.getCapability(capability, facingIn);
    }
}

