/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.gui;

import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.gui.IoConfigRenderer;
import crazypants.enderio.machine.IIoConfigurable;
import crazypants.enderio.machine.IoMode;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.tileentity.TileEntity;

public class GuiOverlayIoConfig<E extends TileEntity>
implements IGuiOverlay {
    private boolean visible = false;
    private ToggleButton configB;
    private IGuiScreen screen;
    private Rectangle bounds;
    int height = 80;
    private IoConfigRenderer<E> renderer;
    private List<BlockCoord> coords = new ArrayList<BlockCoord>();

    public GuiOverlayIoConfig(IIoConfigurable ioConf) {
        this.coords.add(ioConf.getLocation());
    }

    public GuiOverlayIoConfig(Collection<BlockCoord> bc) {
        this.coords.addAll(bc);
    }

    public void setConfigB(ToggleButton configB) {
        this.configB = configB;
    }

    public void init(IGuiScreen screenIn) {
        this.screen = screenIn;
        this.renderer = new IoConfigRenderer<E>(this.coords){

            @Override
            protected String getLabelForMode(IoMode mode) {
                return GuiOverlayIoConfig.this.getLabelForMode(mode);
            }
        };
        this.renderer.init();
        this.bounds = new Rectangle(screenIn.getOverlayOffsetX() + 5, screenIn.getYSize() - this.height - 5, screenIn.getXSize() - 10, this.height);
    }

    protected String getLabelForMode(IoMode mode) {
        return mode.getLocalisedName();
    }

    public void draw(int mouseX, int mouseY, float partialTick) {
        RenderUtil.renderQuad2D((double)this.bounds.x, (double)this.bounds.y, (double)0.0, (double)this.bounds.width, (double)this.bounds.height, (int)ColorUtil.getRGB((Color)Color.black));
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        int vpx = (this.screen.getGuiLeft() + this.bounds.x - this.screen.getOverlayOffsetX()) * scaledresolution.func_78325_e();
        int vpy = (this.screen.getGuiTop() + 4) * scaledresolution.func_78325_e();
        int w = this.bounds.width * scaledresolution.func_78325_e();
        int h = this.bounds.height * scaledresolution.func_78325_e();
        this.renderer.drawScreen(mouseX, mouseY, partialTick, new Rectangle(vpx, vpy, w, h), this.bounds);
    }

    public boolean handleMouseInput(int x, int y, int b) {
        if (!this.isMouseInBounds(x, y)) {
            this.renderer.handleMouseInput();
            return false;
        }
        this.renderer.handleMouseInput();
        return true;
    }

    public boolean isMouseInBounds(int mouseX, int mouseY) {
        int y;
        int x = mouseX - this.screen.getGuiLeft() + this.screen.getOverlayOffsetX();
        return this.bounds.contains(x, y = mouseY - this.screen.getGuiTop());
    }

    public void setIsVisible(boolean visible) {
        this.visible = visible;
        if (this.configB != null) {
            this.configB.setSelected(visible);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public IoConfigRenderer.SelectedFace<E> getSelection() {
        return this.visible ? this.renderer.getSelection() : null;
    }

    public void guiClosed() {
    }
}

