/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.stirling;

import crazypants.enderio.GuiID;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.generator.stirling.GuiStirlingGenerator;
import crazypants.enderio.machine.generator.stirling.PacketBurnTime;
import crazypants.enderio.machine.generator.stirling.StirlingGeneratorContainer;
import crazypants.enderio.machine.generator.stirling.TileEntityStirlingGenerator;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.render.IBlockStateWrapper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStirlingGenerator
extends AbstractMachineBlock<TileEntityStirlingGenerator>
implements IPaintable.ISolidBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    public static BlockStirlingGenerator create() {
        PacketHandler.INSTANCE.registerMessage(PacketBurnTime.class, PacketBurnTime.class, PacketHandler.nextID(), Side.CLIENT);
        BlockStirlingGenerator gen = new BlockStirlingGenerator();
        gen.init();
        return gen;
    }

    protected BlockStirlingGenerator() {
        super(ModObject.blockStirlingGenerator, TileEntityStirlingGenerator.class);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new StirlingGeneratorContainer(player.field_71071_by, (TileEntityStirlingGenerator)world.func_175625_s(new BlockPos(x, y, z)));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiStirlingGenerator(player.field_71071_by, (TileEntityStirlingGenerator)world.func_175625_s(new BlockPos(x, y, z)));
    }

    @Override
    protected GuiID getGuiId() {
        return GuiID.GUI_ID_STIRLING_GEN;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState bs, World world, BlockPos pos, Random rand) {
        TileEntityStirlingGenerator te = (TileEntityStirlingGenerator)world.func_175625_s(pos);
        if (te != null && te.isActive()) {
            EnumFacing front = te.facing;
            for (int i = 0; i < 2; ++i) {
                double px = (double)pos.func_177958_n() + 0.5 + (double)front.func_82601_c() * 0.6;
                double pz = (double)pos.func_177952_p() + 0.5 + (double)front.func_82599_e() * 0.6;
                double v = 0.05;
                double vx = 0.0;
                double vz = 0.0;
                if (front == EnumFacing.NORTH || front == EnumFacing.SOUTH) {
                    px += (double)world.field_73012_v.nextFloat() * 0.9 - 0.45;
                    vz += front == EnumFacing.NORTH ? -v : v;
                } else {
                    pz += (double)world.field_73012_v.nextFloat() * 0.9 - 0.45;
                    vx += front == EnumFacing.WEST ? -v : v;
                }
                if (te.isLavaFired && rand.nextInt(40) == 0) {
                    world.func_175688_a(EnumParticleTypes.LAVA, px, (double)pos.func_177956_o() + 0.1, pz, 0.0, 0.0, 0.0, new int[0]);
                }
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, px, (double)pos.func_177956_o() + 0.1, pz, vx, 0.0, vz, new int[0]);
            }
        }
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileEntityStirlingGenerator tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing()).addCacheKey(tileEntity.isActive());
    }
}

