/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import crazypants.util.Things;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TreeHarvestUtil {
    private static final Things LEAVES = new Things("treeLeaves");
    private static final Things NOT_LEAVES = new Things(new String[0]);
    private int horizontalRange;
    private int verticalRange;
    private BlockPos origin;

    public void harvest(TileFarmStation farm, TreeFarmer farmer, BlockPos bc, HarvestResult res) {
        this.horizontalRange = farm.getFarmSize() + 7;
        this.verticalRange = 30;
        this.origin = farm.func_174877_v().func_185334_h();
        if (farmer.getIgnoreMeta()) {
            this.harvestUp(farm.func_145831_w(), bc, res, new BaseHarvestTarget(null, farmer));
        } else {
            this.harvestUp(farm.func_145831_w(), bc, res, new HarvestTarget(null, farmer));
        }
    }

    public void harvest(World world, BlockPos bc, HarvestResult res) {
        this.horizontalRange = 12;
        this.verticalRange = 30;
        this.origin = bc.func_185334_h();
        IBlockState wood = world.func_180495_p(bc);
        this.harvestUp(world, bc, res, new HarvestTarget(wood, null));
    }

    protected void harvestUp(World world, BlockPos bc, HarvestResult res, BaseHarvestTarget target) {
        if (!this.isInHarvestBounds(bc) || res.harvestedBlocks.contains(bc)) {
            return;
        }
        IBlockState bs = world.func_180495_p(bc);
        boolean isLeaves = TreeHarvestUtil.isLeaves(bs);
        if (target.isTarget(bs) || isLeaves) {
            res.harvestedBlocks.add(bc);
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir == EnumFacing.DOWN) continue;
                this.harvestUp(world, bc.func_177972_a(dir), res, target);
            }
        } else {
            this.harvestAdjacentWood(world, bc, res, target);
            this.harvestAdjacentWood(world, bc.func_177977_b(), res, target);
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                BlockPos loc = bc.func_177972_a(dir);
                IBlockState locBS = world.func_180495_p(loc);
                if (!TreeHarvestUtil.isLeaves(locBS)) continue;
                this.harvestAdjacentWood(world, loc, res, target);
            }
        }
    }

    static boolean isLeaves(IBlockState bs) {
        return (bs.func_185904_a() == Material.field_151584_j || LEAVES.contains(bs.func_177230_c())) && !NOT_LEAVES.contains(bs.func_177230_c());
    }

    private void harvestAdjacentWood(World world, BlockPos bc, HarvestResult res, BaseHarvestTarget target) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            BlockPos targ = bc.func_177972_a(dir);
            if (!target.isTarget(world.func_180495_p(targ))) continue;
            this.harvestUp(world, targ, res, target);
        }
    }

    private boolean isInHarvestBounds(BlockPos bc) {
        int dist = Math.abs(this.origin.func_177958_n() - bc.func_177958_n());
        if (dist > this.horizontalRange) {
            return false;
        }
        dist = Math.abs(this.origin.func_177952_p() - bc.func_177952_p());
        if (dist > this.horizontalRange) {
            return false;
        }
        dist = Math.abs(this.origin.func_177956_o() - bc.func_177956_o());
        return dist <= this.verticalRange;
    }

    public static void addLeavesExcemption(Block block) {
        NOT_LEAVES.add(block);
    }

    private static class BaseHarvestTarget {
        private final Block wood;
        private final TreeFarmer farmer;

        BaseHarvestTarget(Block wood, TreeFarmer farmer) {
            this.wood = wood;
            this.farmer = farmer;
        }

        boolean isTarget(IBlockState bs) {
            return this.farmer != null ? this.farmer.isWood(bs.func_177230_c()) : bs.func_177230_c() == this.wood;
        }
    }

    private static final class HarvestTarget
    extends BaseHarvestTarget {
        final BlockPlanks.EnumType variant;

        HarvestTarget(IBlockState bs, TreeFarmer farmer) {
            super(bs == null ? null : bs.func_177230_c(), farmer);
            this.variant = HarvestTarget.getVariant(bs);
        }

        static BlockPlanks.EnumType getVariant(IBlockState bs) {
            try {
                return (BlockPlanks.EnumType)bs.func_177229_b((IProperty)BlockNewLog.field_176300_b);
            }
            catch (Exception exception) {
                try {
                    return (BlockPlanks.EnumType)bs.func_177229_b((IProperty)BlockOldLog.field_176301_b);
                }
                catch (Exception exception2) {
                    return null;
                }
            }
        }

        @Override
        boolean isTarget(IBlockState bs) {
            if (this.variant == null) {
                return super.isTarget(bs);
            }
            return super.isTarget(bs) && this.variant == HarvestTarget.getVariant(bs);
        }
    }
}

