/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import crazypants.enderio.integration.bop.BoPUtil;
import crazypants.enderio.integration.botania.BotaniaUtil;
import crazypants.enderio.integration.botany.BotanyUtil;
import crazypants.enderio.integration.exu2.ExU2Util;
import crazypants.enderio.integration.forestry.ForestryUtil;
import crazypants.enderio.integration.ic2e.IC2eUtil;
import crazypants.enderio.integration.immersiveengineering.ImmersiveEngineeringUtil;
import crazypants.enderio.integration.mfr.MFRUtil;
import crazypants.enderio.integration.natura.NaturaUtil;
import crazypants.enderio.integration.techreborn.TechRebornUtil;
import crazypants.enderio.integration.tic.TicUtil;
import crazypants.enderio.machine.farm.farmers.ChorusFarmer;
import crazypants.enderio.machine.farm.farmers.CocoaFarmer;
import crazypants.enderio.machine.farm.farmers.CustomSeedFarmer;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.FlowerPicker;
import crazypants.enderio.machine.farm.farmers.MelonFarmer;
import crazypants.enderio.machine.farm.farmers.NetherWartFarmer;
import crazypants.enderio.machine.farm.farmers.OredictTreeFarmer;
import crazypants.enderio.machine.farm.farmers.PickableFarmer;
import crazypants.enderio.machine.farm.farmers.PlantableFarmer;
import crazypants.enderio.machine.farm.farmers.StemFarmer;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import crazypants.util.Things;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class FarmersRegistry {
    private static final Things SAPLINGS = new Things("treeSapling");
    private static final Things WOODS = new Things("logWood");
    private static final Things FLOWERS = new Things(new String[0]).add((Block)Blocks.field_150327_N).add((Block)Blocks.field_150328_O);
    public static final PlantableFarmer DEFAULT_FARMER = new PlantableFarmer();

    public static void addFarmers() {
        TechRebornUtil.addTechreborn();
        ExU2Util.addExtraUtilities2();
        NaturaUtil.addNatura();
        IC2eUtil.addIC2();
        MFRUtil.addMFR();
        ImmersiveEngineeringUtil.addImmersiveEngineering();
        ForestryUtil.addForestry();
        BotaniaUtil.addBotania();
        BoPUtil.addBoP();
        BotanyUtil.addBotany();
        TicUtil.addTic();
        FarmersCommune.joinCommune(new FlowerPicker(FLOWERS));
        FarmersCommune.joinCommune(new StemFarmer((Block)Blocks.field_150436_aH, new ItemStack(Items.field_151120_aE)));
        FarmersCommune.joinCommune(new StemFarmer((Block)Blocks.field_150434_aF, new ItemStack((Block)Blocks.field_150434_aF)));
        FarmersCommune.joinCommune(new OredictTreeFarmer(SAPLINGS, WOODS));
        FarmersCommune.joinCommune(new TreeFarmer(true, (Block)Blocks.field_150337_Q, Blocks.field_150419_aX));
        FarmersCommune.joinCommune(new TreeFarmer(true, (Block)Blocks.field_150338_P, Blocks.field_150420_aW));
        FarmersCommune.joinCommune(new MelonFarmer(Blocks.field_150394_bc, Blocks.field_150440_ba, new ItemStack(Items.field_151081_bc)));
        FarmersCommune.joinCommune(new MelonFarmer(Blocks.field_150393_bb, Blocks.field_150423_aK, new ItemStack(Items.field_151080_bb)));
        FarmersCommune.joinCommune(new NetherWartFarmer());
        FarmersCommune.joinCommune(new CocoaFarmer());
        FarmersCommune.joinCommune(new ChorusFarmer());
        FarmersCommune.joinCommune(DEFAULT_FARMER);
    }

    public static void addPickable(String mod, String blockName, String itemName) {
        Block cropBlock = FarmersRegistry.findBlock(mod, blockName);
        Item seedItem = FarmersRegistry.findItem(mod, itemName);
        if (cropBlock != null && seedItem != null) {
            FarmersCommune.joinCommune(new PickableFarmer(cropBlock, new ItemStack(seedItem)));
        }
    }

    public static CustomSeedFarmer addSeed(String mod, String blockName, String itemName, Block ... extraFarmland) {
        Block cropBlock = FarmersRegistry.findBlock(mod, blockName);
        Item seedItem = FarmersRegistry.findItem(mod, itemName);
        if (cropBlock != null && seedItem != null) {
            CustomSeedFarmer farmer = new CustomSeedFarmer(cropBlock, new ItemStack(seedItem));
            if (extraFarmland != null) {
                for (Block farmland : extraFarmland) {
                    if (farmland == null) continue;
                    farmer.addTilledBlock(farmland);
                }
            }
            FarmersCommune.joinCommune(farmer);
            return farmer;
        }
        return null;
    }

    public static Block findBlock(String mod, String blockName) {
        ResourceLocation name = new ResourceLocation(mod, blockName);
        if (Block.field_149771_c.func_148741_d((Object)name)) {
            return (Block)Block.field_149771_c.func_82594_a((Object)name);
        }
        return null;
    }

    public static Item findItem(String mod, String itemName) {
        ResourceLocation name = new ResourceLocation(mod, itemName);
        if (Item.field_150901_e.func_148741_d((Object)name)) {
            return (Item)Item.field_150901_e.func_82594_a((Object)name);
        }
        return null;
    }

    public static void registerFlower(String ... names) {
        for (String name : names) {
            FLOWERS.add(name);
        }
    }

    public static void registerSaplings(String ... names) {
        for (String name : names) {
            SAPLINGS.add(name);
        }
    }

    public static void registerLogs(String ... names) {
        for (String name : names) {
            WOODS.add(name);
        }
    }

    private FarmersRegistry() {
    }
}

