/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.Util;
import crazypants.enderio.BlockEio;
import crazypants.enderio.GuiID;
import crazypants.enderio.IModObject;
import crazypants.enderio.ModObject;
import crazypants.enderio.integration.waila.IWailaInfoProvider;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.AbstractPoweredMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.PacketIoMode;
import crazypants.enderio.machine.PacketPowerStorage;
import crazypants.enderio.machine.RenderMappers;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.render.PaintHelper;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.property.EnumRenderMode;
import crazypants.enderio.render.property.IOMode;
import crazypants.enderio.render.registry.SmartModelAttacher;
import crazypants.enderio.render.registry.TextureRegistry;
import crazypants.util.NullHelper;
import crazypants.util.Prep;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractMachineBlock<T extends AbstractMachineEntity>
extends BlockEio<T>
implements IGuiHandler,
IResourceTooltipProvider,
IWailaInfoProvider,
ISmartRenderAwareBlock {
    public static final TextureRegistry.TextureSupplier selectedFaceIcon = TextureRegistry.registerTexture("blocks/overlays/selectedFace");
    protected final Random random;
    protected final IModObject modObject;

    protected AbstractMachineBlock(@Nonnull IModObject mo, @Nullable Class<T> teClass, @Nonnull Material mat) {
        super(mo.getUnlocalisedName(), teClass, mat);
        this.modObject = mo;
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("pickaxe", 0);
        this.random = new Random();
        this.initDefaultState();
    }

    protected void initDefaultState() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.AUTO)));
    }

    protected AbstractMachineBlock(@Nonnull IModObject mo, @Nullable Class<T> teClass) {
        this(mo, teClass, new Material(MapColor.field_151668_h));
    }

    protected void init() {
        super.init();
        GuiID.registerGuiHandler(this.getGuiId(), this);
        this.registerInSmartModelAttacher();
    }

    protected void registerInSmartModelAttacher() {
        SmartModelAttacher.register((Block)this);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumRenderMode.RENDER});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.func_176223_P();
    }

    @SideOnly(value=Side.CLIENT)
    public final IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperBase blockStateWrapper = this.createBlockStateWrapper(state, world, pos);
            AbstractMachineEntity tileEntity = (AbstractMachineEntity)this.getTileEntitySafe(world, pos);
            if (tileEntity != null) {
                this.setBlockStateWrapperCache(blockStateWrapper, world, pos, tileEntity);
            }
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    protected abstract void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper var1, @Nonnull IBlockAccess var2, @Nonnull BlockPos var3, @Nonnull T var4);

    @Nonnull
    protected BlockStateWrapperBase createBlockStateWrapper(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return new BlockStateWrapperBase(state, world, pos, this.getBlockRenderMapper());
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        GuiID guiId = this.getGuiId();
        if (guiId != null) {
            guiId.openGui(world, pos, entityPlayer, side);
        }
        return true;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean doNormalDrops(IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected void processDrop(IBlockAccess world, BlockPos pos, @Nullable AbstractMachineEntity te, ItemStack drop) {
        if (te != null) {
            te.writeToItemStack(drop);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.func_180633_a(world, pos, state, player, stack);
        if (world != null && pos != null) {
            AbstractMachineEntity te = (AbstractMachineEntity)this.getTileEntity((IBlockAccess)world, pos);
            if (te != null) {
                te.readFromItemStack(stack);
                if (player != null) {
                    te.setFacing(this.getFacingForHeading(player));
                    if (player instanceof EntityPlayer && !world.field_72995_K) {
                        te.setOwner((EntityPlayer)player);
                    }
                }
            }
            if (world.field_72995_K) {
                return;
            }
            world.func_184138_a(pos, state, state, 3);
        }
    }

    protected EnumFacing getFacingForHeading(EntityLivingBase player) {
        return Util.getFacingFromEntity((EntityLivingBase)player);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_184138_a(pos, state, state, 3);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        AbstractMachineEntity te = (AbstractMachineEntity)this.getTileEntity((IBlockAccess)world, pos);
        if (te != null) {
            te.onNeighborBlockChange(neighborBlock);
        }
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        AbstractPoweredMachineEntity machine;
        AbstractMachineEntity tile = (AbstractMachineEntity)this.getTileEntity((IBlockAccess)world, pos);
        if (Prep.isValid(heldItem) && tile instanceof AbstractPoweredMachineEntity && (machine = (AbstractPoweredMachineEntity)tile).getSlotDefinition().getNumUpgradeSlots() > 0 && heldItem.func_77973_b() == ModObject.itemBasicCapacitor.getItem()) {
            int slot = machine.getSlotDefinition().getMinUpgradeSlot();
            ItemStack toInsert = heldItem.func_77946_l();
            toInsert.field_77994_a = 1;
            ItemStack temp = machine.func_70301_a(slot);
            if (Prep.isInvalid(temp)) {
                machine.func_70299_a(slot, toInsert);
                toInsert = null;
            } else if (temp.func_77952_i() != toInsert.func_77952_i()) {
                machine.func_70299_a(slot, toInsert);
                toInsert = temp;
            } else {
                return super.func_180639_a(world, pos, state, entityPlayer, hand, heldItem, side, hitX, hitY, hitZ);
            }
            --heldItem.field_77994_a;
            if (heldItem.field_77994_a == 0) {
                entityPlayer.func_184611_a(hand, null);
            }
            if (toInsert != null && !entityPlayer.field_71071_by.func_70441_a(toInsert)) {
                entityPlayer.func_71019_a(toInsert, true);
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, entityPlayer, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState bs, World world, BlockPos pos, Random rand) {
        if (world != null && pos != null && rand != null) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (this.isActive((IBlockAccess)world, pos)) {
                float startX = (float)x + 1.0f;
                float startY = (float)y + 1.0f;
                float startZ = (float)z + 1.0f;
                for (int i = 0; i < 4; ++i) {
                    float xOffset = -0.2f - rand.nextFloat() * 0.6f;
                    float yOffset = -0.1f + rand.nextFloat() * 0.2f;
                    float zOffset = -0.2f - rand.nextFloat() * 0.6f;
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(startX + xOffset), (double)(startY + yOffset), (double)(startZ + zOffset), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    protected abstract GuiID getGuiId();

    protected boolean isActive(@Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos) {
        AbstractMachineEntity te = (AbstractMachineEntity)this.getTileEntitySafe(blockAccess, pos);
        if (te != null) {
            return te.isActive();
        }
        return false;
    }

    @Deprecated
    protected boolean isActive(@Nonnull IBlockAccess blockAccess, int x, int y, int z) {
        return this.isActive(blockAccess, new BlockPos(x, y, z));
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_149739_a();
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 7;
    }

    @SideOnly(value=Side.CLIENT)
    public IOMode.EnumIOMode mapIOMode(IoMode mode, EnumFacing side) {
        switch (mode) {
            case NONE: {
                return IOMode.EnumIOMode.NONE;
            }
            case PULL: {
                return IOMode.EnumIOMode.PULL;
            }
            case PUSH: {
                return IOMode.EnumIOMode.PUSH;
            }
            case PUSH_PULL: {
                return IOMode.EnumIOMode.PUSHPULL;
            }
            case DISABLED: {
                return IOMode.EnumIOMode.DISABLED;
            }
        }
        throw new RuntimeException("Hey, leave our enums alone!");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return RenderMappers.BODY_MAPPER;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return RenderMappers.BODY_MAPPER;
    }

    @Nonnull
    public IBlockState getFacade(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        NullHelper.notnull(world, "Hey, how should I get you a block state without a world or position?");
        NullHelper.notnull(pos, "Hey, how should I get you a block state without a world or position?");
        IBlockState paintSource = this.getPaintSource(this.func_176223_P(), world, pos);
        return paintSource != null ? paintSource : NullHelper.notnullM(world.func_180495_p(pos), "world.getBlockState(pos)");
    }

    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        AbstractMachineEntity te;
        if (this instanceof IPaintable && world != null && pos != null && (te = (AbstractMachineEntity)this.getTileEntity(world, pos)) instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)((Object)te)).setPaintSource(paintSource);
        }
    }

    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        if (this instanceof IPaintable) {
            PainterUtil2.setSourceBlock(stack, paintSource);
        }
    }

    @Nullable
    public IBlockState getPaintSource(@Nullable IBlockState state, IBlockAccess world, BlockPos pos) {
        AbstractMachineEntity te;
        if (this instanceof IPaintable && world != null && pos != null && (te = (AbstractMachineEntity)this.getTileEntitySafe(world, pos)) instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)((Object)te)).getPaintSource();
        }
        return null;
    }

    @Nullable
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        if (this instanceof IPaintable) {
            return PainterUtil2.getSourceBlock(stack);
        }
        return null;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return this instanceof IPaintable ? true : super.canRenderInLayer(state, layer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }

    static {
        PacketHandler.INSTANCE.registerMessage(PacketIoMode.Handler.class, PacketIoMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketPowerStorage.class, PacketPowerStorage.class, PacketHandler.nextID(), Side.CLIENT);
    }
}

