/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.OreDictionaryHelper;
import com.google.common.collect.Sets;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpoonUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TravelUpgrade;
import crazypants.enderio.material.Alloy;
import crazypants.enderio.power.PowerDisplayUtil;
import crazypants.enderio.teleport.TravelController;
import crazypants.util.Prep;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDarkSteelPickaxe
extends ItemPickaxe
implements IAdvancedTooltipProvider,
IDarkSteelItem,
IItemOfTravel,
EnderCoreMethods.IOverlayRenderAware {
    @Nonnull
    public static final String NAME = "darkSteel_pickaxe";
    private long lastBlickTick = -1L;

    public static boolean isEquipped(EntityPlayer player, EnumHand hand) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_184586_b(hand);
        if (Prep.isInvalid(equipped)) {
            return false;
        }
        return equipped.func_77973_b() == DarkSteelItems.itemDarkSteelPickaxe;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, EnumHand hand, int requiredPower) {
        if (!ItemDarkSteelPickaxe.isEquipped(player, hand)) {
            return false;
        }
        return EnergyUpgrade.getEnergyStored(player.func_184586_b(hand)) >= requiredPower;
    }

    public static ItemDarkSteelPickaxe create() {
        ItemDarkSteelPickaxe res = new ItemDarkSteelPickaxe();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    public ItemDarkSteelPickaxe() {
        super(ItemDarkSteelSword.MATERIAL);
        this.func_77637_a(EnderIOTab.tabEnderIOItems);
        this.func_77655_b(NAME);
        this.setRegistryName(NAME);
    }

    @Override
    public String getItemName() {
        return NAME;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        TravelUpgrade.INSTANCE.writeToItem(is);
        SpoonUpgrade.INSTANCE.writeToItem(is);
        par3List.add(is);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    @Override
    public boolean isItemForRepair(ItemStack right) {
        return OreDictionaryHelper.hasName((ItemStack)right, (String)Alloy.DARK_STEEL.getOreIngot());
    }

    public boolean func_179218_a(ItemStack item, World world, IBlockState bs, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)bs.func_185887_b(world, pos) != 0.0 && this.useObsidianEffeciency(item, bs)) {
            this.extractInternal(item, Config.darkSteelPickPowerUseObsidian);
        }
        return super.func_179218_a(item, world, bs, pos, entityLiving);
    }

    public EnumActionResult func_180614_a(ItemStack item, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            if (Config.darkSteelRightClickPlaceEnabled) {
                return ItemDarkSteelPickaxe.doRightClickItemPlace(player, world, pos, side, hand, hitX, hitX, hitX);
            }
            if (this.doTravelAction(item, world, player, hand) != null) {
                return EnumActionResult.SUCCESS;
            }
        }
        if (Math.random() < 0.001) {
            Entity cow = EntityList.func_188429_b((String)"Pig", (World)world);
            BlockPos p = pos.func_177972_a(side);
            cow.func_70012_b((double)p.func_177958_n() + 0.5, (double)p.func_177956_o(), (double)p.func_177952_p() + 0.5, 0.0f, 0.0f);
            world.func_72838_d(cow);
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    static EnumActionResult doRightClickItemPlace(EntityPlayer player, World world, BlockPos pos, EnumFacing side, EnumHand hand, float par8, float par9, float par10) {
        int slot;
        if (!Config.darkSteelRightClickPlaceEnabled || hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        int current = player.field_71071_by.field_70461_c;
        int n = slot = current == 0 && Config.slotZeroPlacesEight ? 8 : current + 1;
        if (slot < 9 && Prep.isValid(player.field_71071_by.field_70462_a[slot]) && !(player.field_71071_by.field_70462_a[slot].func_77973_b() instanceof IDarkSteelItem)) {
            player.field_71071_by.field_70461_c = slot;
            Minecraft mc = Minecraft.func_71410_x();
            EnumActionResult result = mc.field_71442_b.func_187099_a(mc.field_71439_g, mc.field_71441_e, player.field_71071_by.field_70462_a[slot], pos, side, new Vec3d((double)par8, (double)par9, (double)par10), hand);
            player.field_71071_by.field_70461_c = current;
            return result;
        }
        return EnumActionResult.PASS;
    }

    public void setDamage(ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        } else {
            int damage = newDamage - oldDamage;
            if (!this.absorbDamageWithEnergy(stack, damage * Config.darkSteelPickPowerUsePerDamagePoint)) {
                super.setDamage(stack, newDamage);
            }
        }
    }

    private boolean absorbDamageWithEnergy(ItemStack stack, int amount) {
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower() && eu.getEnergy() > 0) {
            eu.extractEnergy(amount, false);
            eu.writeToItem(stack);
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(IBlockState block, ItemStack item) {
        if (this.hasSpoonUpgrade(item) && this.getEnergyStored(item) > 0) {
            return block.func_177230_c() == Blocks.field_150431_aC || block.func_177230_c() == Blocks.field_150433_aE || super.canHarvestBlock(block, item);
        }
        return super.canHarvestBlock(block, item);
    }

    private boolean hasSpoonUpgrade(ItemStack item) {
        return SpoonUpgrade.loadFromItem(item) != null;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (state.func_185904_a() == Material.field_151592_s) {
            return this.field_77862_b.func_77998_b();
        }
        if (this.useObsidianEffeciency(stack, state)) {
            return this.field_77862_b.func_77998_b() + Config.darkSteelPickEffeciencyBoostWhenPowered + (float)Config.darkSteelPickEffeciencyObsidian;
        }
        if (ItemDarkSteelPickaxe.isToolEffective(state, stack)) {
            if (Config.darkSteelPickPowerUsePerDamagePoint <= 0 ? EnergyUpgrade.itemHasAnyPowerUpgrade(stack) : EnergyUpgrade.getEnergyStored(stack) > 0) {
                return this.field_77862_b.func_77998_b() + Config.darkSteelPickEffeciencyBoostWhenPowered;
            }
            return this.field_77862_b.func_77998_b();
        }
        return super.func_150893_a(stack, state);
    }

    public static boolean isToolEffective(IBlockState state, ItemStack stack) {
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    private boolean useObsidianEffeciency(ItemStack item, IBlockState blockState) {
        boolean useObsidianSpeed = false;
        int energy = this.getEnergyStored(item);
        if (energy > Config.darkSteelPickPowerUseObsidian) {
            boolean bl = useObsidianSpeed = blockState.func_177230_c() == Blocks.field_150343_Z;
            if (!useObsidianSpeed && Config.darkSteelPickApplyObsidianEffeciencyAtHardess > 0.0f) {
                try {
                    useObsidianSpeed = blockState.func_185887_b(null, new BlockPos(-1, -1, -1)) >= Config.darkSteelPickApplyObsidianEffeciencyAtHardess;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return useObsidianSpeed;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet set = Sets.newHashSet((Object[])new String[]{"pickaxe"});
        if (this.hasSpoonUpgrade(stack)) {
            set.add("shovel");
        }
        return set;
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(TextFormatting.WHITE + "+" + Config.darkSteelPickEffeciencyBoostWhenPowered + " " + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.effPowered"));
            list.add(TextFormatting.WHITE + "+" + Config.darkSteelPickEffeciencyObsidian + " " + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.effObs") + " ");
            list.add(TextFormatting.WHITE + "     (" + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.cost") + " " + PowerDisplayUtil.formatPower(Config.darkSteelPickPowerUseObsidian) + " " + PowerDisplayUtil.abrevation() + ")");
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    @Override
    public boolean isActive(EntityPlayer ep, ItemStack equipped) {
        return this.isTravelUpgradeActive(ep, equipped, EnumHand.MAIN_HAND) || this.isTravelUpgradeActive(ep, equipped, EnumHand.OFF_HAND);
    }

    @Override
    public void extractInternal(ItemStack equipped, int power) {
        EnergyUpgrade.extractEnergy(equipped, power, false);
    }

    private boolean isTravelUpgradeActive(EntityPlayer ep, ItemStack equipped, EnumHand hand) {
        return ItemDarkSteelPickaxe.isEquipped(ep, hand) && ep.func_70093_af() && TravelUpgrade.loadFromItem(equipped) != null;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        ActionResult doTravelAction = this.doTravelAction(stack, world, player, hand);
        return doTravelAction != null ? doTravelAction : super.func_77659_a(stack, world, player, hand);
    }

    protected ActionResult<ItemStack> doTravelAction(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (this.isTravelUpgradeActive(player, stack, hand)) {
            if (world.field_72995_K && TravelController.instance.activateTravelAccessable(stack, hand, world, player, TravelSource.STAFF)) {
                player.func_184609_a(hand);
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (Config.travelStaffBlinkEnabled && world.field_72995_K && ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(stack, hand, player)) {
                player.func_184609_a(hand);
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        return null;
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || Prep.isInvalid(oldStack) || Prep.isInvalid(newStack) || oldStack.func_77973_b() != newStack.func_77973_b();
    }
}

