/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.natura;

import crazypants.enderio.machine.farm.FarmNotification;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.PickableFarmer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class NaturaBerryFarmer
extends PickableFarmer {
    public NaturaBerryFarmer(Block plantedBlock, int plantedBlockMeta, int grownBlockMeta, ItemStack seeds) {
        super(plantedBlock, plantedBlockMeta, grownBlockMeta, seeds);
        this.requiresFarmland = false;
        this.checkGroundForFarmland = false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockPos bc, Block block, IBlockState meta) {
        if (block != this.getPlantedBlock()) {
            return null;
        }
        if (!farm.hasHoe()) {
            farm.setNotification(FarmNotification.NO_HOE);
            return null;
        }
        HarvestResult res = new HarvestResult();
        BlockPos checkBlock = bc;
        while (checkBlock != null && checkBlock.func_177956_o() <= 255 && farm.hasHoe()) {
            IHarvestResult blockRes;
            meta = farm.getBlockState(checkBlock);
            block = farm.getBlock(checkBlock);
            if (block != this.getPlantedBlock()) {
                checkBlock = null;
                continue;
            }
            if (this.getFullyGrownBlockMeta() == block.func_176201_c(meta) && (blockRes = super.harvestBlock(farm, checkBlock, block, meta)) != null) {
                res.getHarvestedBlocks().add(checkBlock);
                res.getDrops().addAll(blockRes.getDrops());
            }
            checkBlock = checkBlock.func_177984_a();
        }
        if (res.getHarvestedBlocks().isEmpty()) {
            return null;
        }
        return res;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockPos bc, Block block, IBlockState bs) {
        BlockPos checkBlock = bc;
        while (checkBlock.func_177956_o() <= 255) {
            bs = farm.getBlockState(checkBlock);
            block = bs.func_177230_c();
            if (block != this.getPlantedBlock()) {
                return false;
            }
            if (super.canHarvest(farm, checkBlock, block, bs)) {
                return true;
            }
            checkBlock = checkBlock.func_177984_a();
        }
        return false;
    }
}

