/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.registry;

import crazypants.enderio.Log;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.geom.Offsets;
import crazypants.enderio.conduit.render.ConduitRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConduitRegistry {
    private static final List<ConduitInfo> conduitInfos = new ArrayList<ConduitInfo>();
    private static final Map<Class<? extends IConduit>, ConduitInfo> conduitCLassMap = new IdentityHashMap<Class<? extends IConduit>, ConduitInfo>();
    private static final Map<UUID, ConduitInfo> conduitUUIDMap = new HashMap<UUID, ConduitInfo>();
    private static final Map<Class<? extends IConduit>, UUID> conduitMemberMapF = new IdentityHashMap<Class<? extends IConduit>, UUID>();
    private static final Map<UUID, Class<? extends IConduit>> conduitMemberMapR = new HashMap<UUID, Class<? extends IConduit>>();
    private static boolean sortingSupported = true;
    private static final Comparator<ConduitInfo> UUID_COMPERATOR = new Comparator<ConduitInfo>(){

        @Override
        public int compare(ConduitInfo o1, ConduitInfo o2) {
            return o1.getNetworkUUID().compareTo(o2.getNetworkUUID());
        }
    };
    private static final Comparator<IConduit> CONDUIT_COMPERATOR = new Comparator<IConduit>(){

        @Override
        public int compare(IConduit o1, IConduit o2) {
            return ConduitRegistry.get(o1).getNetworkUUID().compareTo(ConduitRegistry.get(o2).getNetworkUUID());
        }
    };

    public static void registerAlias(Class<? extends IConduit> member, String aliasName) {
        UUID uuid = UUID.nameUUIDFromBytes(aliasName.getBytes());
        conduitMemberMapR.put(uuid, member);
    }

    public static void registerAlias(ConduitInfo info, String aliasName) {
        UUID uuid = UUID.nameUUIDFromBytes(aliasName.getBytes());
        conduitUUIDMap.put(uuid, info);
    }

    public static void register(ConduitInfo info) {
        conduitInfos.add(info);
        Collections.sort(conduitInfos, UUID_COMPERATOR);
        conduitUUIDMap.put(info.getNetworkUUID(), info);
        conduitCLassMap.put(info.getBaseType(), info);
        for (Class<? extends IConduit> member : info.getMembers()) {
            conduitCLassMap.put(member, info);
            UUID uuid = UUID.nameUUIDFromBytes(member.getName().getBytes());
            conduitMemberMapF.put(member, uuid);
            conduitMemberMapR.put(uuid, member);
        }
        Offset none = info.getNone();
        Offset x = info.getX();
        Offset y = info.getY();
        Offset z = info.getZ();
        while (!Offsets.registerOffsets(info.getBaseType(), none, x, y, z)) {
            if ((z = z.next()) == null) {
                z = Offset.first();
            }
            if (z == info.getZ()) {
                if ((y = y.next()) == null) {
                    y = Offset.first();
                }
                if (y == info.getY()) {
                    if ((x = x.next()) == null) {
                        x = Offset.first();
                    }
                    if (x == info.getX() && (none = none.next()) == null) {
                        none = Offset.first();
                    }
                }
            }
            if (z != info.getZ() || y != info.getY() || x != info.getX() || none != info.getNone()) continue;
            throw new RuntimeException("Failed to find free offsets for " + info.getBaseType());
        }
    }

    public static void injectMember(ConduitInfo info, Class<? extends IConduit> member) {
        if (!conduitInfos.contains(info)) {
            throw new IllegalArgumentException("The specified ConduitInfo has not been added yet");
        }
        conduitCLassMap.put(member, info);
        UUID uuid = UUID.nameUUIDFromBytes(member.getName().getBytes());
        conduitMemberMapF.put(member, uuid);
        conduitMemberMapR.put(uuid, member);
    }

    public static ConduitInfo get(IConduit conduit) {
        return conduitCLassMap.get(conduit.getClass());
    }

    public static ConduitInfo get(UUID uuid) {
        return conduitUUIDMap.get(uuid);
    }

    public static Collection<ConduitInfo> getAll() {
        return conduitInfos;
    }

    public static IConduit getInstance(UUID uuid) {
        Class<? extends IConduit> clazz = conduitMemberMapR.get(uuid);
        if (clazz == null) {
            Log.warn("Ignoring unregistered conduit type " + uuid);
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create an instance of the conduit of type " + uuid, e);
        }
    }

    public static UUID getInstanceUUID(IConduit conduit) {
        return conduitMemberMapF.get(conduit.getClass());
    }

    public static void sort(List<IConduit> conduits) {
        if (sortingSupported) {
            try {
                Collections.sort(conduits, CONDUIT_COMPERATOR);
            }
            catch (UnsupportedOperationException e) {
                sortingSupported = false;
            }
        }
    }

    public static class ConduitInfo {
        @Nonnull
        private final UUID networkUUID;
        @Nonnull
        private final Class<? extends IConduit> baseType;
        @Nonnull
        private final Offset none;
        @Nonnull
        private final Offset x;
        @Nonnull
        private final Offset y;
        @Nonnull
        private final Offset z;
        private boolean canConnectToAnything;
        @SideOnly(value=Side.CLIENT)
        @Nullable
        private Collection<ConduitRenderer> renderers;
        @Nonnull
        private Collection<Class<? extends IConduit>> members = new ArrayList<Class<? extends IConduit>>();

        public ConduitInfo(@Nonnull Class<? extends IConduit> baseType, @Nonnull Offset none, @Nonnull Offset x, @Nonnull Offset y, @Nonnull Offset z) {
            this.baseType = baseType;
            this.none = none;
            this.x = x;
            this.y = y;
            this.z = z;
            this.networkUUID = UUID.nameUUIDFromBytes(baseType.getName().getBytes());
        }

        @Nonnull
        public UUID getNetworkUUID() {
            return this.networkUUID;
        }

        @Nonnull
        public Class<? extends IConduit> getBaseType() {
            return this.baseType;
        }

        public void setCanConnectToAnything() {
            this.canConnectToAnything = true;
        }

        public boolean canConnectToAnything() {
            return this.canConnectToAnything;
        }

        @SideOnly(value=Side.CLIENT)
        public void addRenderer(@Nonnull ConduitRenderer renderer) {
            if (this.renderers == null) {
                this.renderers = new ArrayList<ConduitRenderer>();
            }
            this.renderers.add(renderer);
        }

        @SideOnly(value=Side.CLIENT)
        @Nonnull
        public Collection<ConduitRenderer> getRenderers() {
            if (this.renderers == null) {
                return Collections.emptyList();
            }
            return this.renderers;
        }

        public void addMember(@Nonnull Class<? extends IConduit> member) {
            this.members.add(member);
        }

        @Nonnull
        public Collection<Class<? extends IConduit>> getMembers() {
            return this.members;
        }

        @Nonnull
        protected Offset getNone() {
            return this.none;
        }

        @Nonnull
        protected Offset getX() {
            return this.x;
        }

        @Nonnull
        protected Offset getY() {
            return this.y;
        }

        @Nonnull
        protected Offset getZ() {
            return this.z;
        }
    }
}

