/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio;

import com.enderio.core.common.Lang;
import com.enderio.core.common.util.EntityUtil;
import com.google.common.collect.ImmutableList;
import crazypants.enderio.CommonProxy;
import crazypants.enderio.GuiID;
import crazypants.enderio.Log;
import crazypants.enderio.MigrationMapper;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.ConduitNetworkTickHandler;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.redstone.InsulatedRedstoneConduit;
import crazypants.enderio.config.Config;
import crazypants.enderio.diagnostics.EnderIOCrashCallable;
import crazypants.enderio.enchantment.Enchantments;
import crazypants.enderio.fluid.FluidFuelRegister;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.integration.bigreactors.BRProxy;
import crazypants.enderio.integration.buildcraft.BuildcraftIntegration;
import crazypants.enderio.integration.chiselsandbits.CABIMC;
import crazypants.enderio.integration.te.TEIntegration;
import crazypants.enderio.integration.tic.TicProxy;
import crazypants.enderio.integration.waila.WailaIMC;
import crazypants.enderio.item.darksteel.DarkSteelController;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.loot.Loot;
import crazypants.enderio.loot.LootManager;
import crazypants.enderio.machine.alloy.AlloyRecipeManager;
import crazypants.enderio.machine.enchanter.EnchanterRecipeManager;
import crazypants.enderio.machine.farm.FarmersRegistry;
import crazypants.enderio.machine.sagmill.SagMillRecipeManager;
import crazypants.enderio.machine.slicensplice.SliceAndSpliceRecipeManager;
import crazypants.enderio.machine.soul.SoulBinderRecipeManager;
import crazypants.enderio.machine.spawner.PoweredSpawnerConfig;
import crazypants.enderio.machine.transceiver.ServerChannelRegister;
import crazypants.enderio.machine.vat.VatRecipeManager;
import crazypants.enderio.material.MaterialRecipes;
import crazypants.enderio.material.OreDictionaryPreferences;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.PaintSourceValidator;
import crazypants.enderio.power.CapInjectHandler;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.render.dummy.BlockMachineBase;
import crazypants.enderio.render.dummy.BlockMachineIO;
import crazypants.util.CapturedMob;
import crazypants.util.NullHelper;
import crazypants.util.Things;
import info.loenwind.scheduler.Celeb;
import info.loenwind.scheduler.Scheduler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;

@Mod(modid="EnderIO", name="Ender IO", version="1.10.2-3.1.193", dependencies="required-after:Forge@[12.18.2.2122,);required-after:endercore@[1.10.2-0.4.1.63-beta,);after:Waila@[1.7.0-B3_1.9.4,);after:JEI@[3.13.4.384,)", guiFactory="crazypants.enderio.config.ConfigFactoryEIO", acceptedMinecraftVersions="[1.10.2]")
public class EnderIO {
    @Nonnull
    public static final String MODID = "EnderIO";
    @Nonnull
    public static final String DOMAIN = NullHelper.notnullJ("EnderIO".toLowerCase(Locale.US), "String.toLowerCase()");
    public static final String MOD_NAME = "Ender IO";
    public static final String VERSION = "1.10.2-3.1.193";
    @Mod.Instance(value="EnderIO")
    public static EnderIO instance;
    @SidedProxy(clientSide="crazypants.enderio.ClientProxy", serverSide="crazypants.enderio.CommonProxy")
    public static CommonProxy proxy;
    public static final PacketHandler packetPipeline;
    public static final Lang lang;
    public static Fluids fluids;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        EnderIOCrashCallable.create();
        PowerHandlerUtil.create();
        Config.preInit(event);
        proxy.loadIcons();
        BlockMachineBase.create();
        BlockMachineIO.create();
        ConduitGeometryUtil.setupBounds((float)Config.conduitScale);
        fluids = new Fluids();
        fluids.registerFluids();
        TicProxy.init(event);
        URL authlib = this.getClass().getClassLoader().getResource("com/mojang/authlib/GameProfile.class");
        if (authlib == null || !authlib.toString().contains("/tlauncher/")) {
            ModObject.preInit(event);
        }
        DarkSteelItems.createDarkSteelArmorItems();
        DarkSteelController.instance.register();
        WailaIMC.init(event);
        MaterialRecipes.registerOresInDictionary();
        Loot.create();
        BRProxy.init(event);
        proxy.init(event);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        Things.init(event);
        Config.init(event);
        instance = this;
        ModObject.init(event);
        CABIMC.init(event);
        PacketHandler.init(event);
        GuiID.init();
        MaterialRecipes.registerDependantOresInDictionary();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Config.postInit();
        LootManager.register();
        Enchantments.register();
        OreDictionaryPreferences.loadConfig();
        SagMillRecipeManager.getInstance().loadRecipesFromConfig();
        AlloyRecipeManager.getInstance().loadRecipesFromConfig();
        SliceAndSpliceRecipeManager.getInstance().loadRecipesFromConfig();
        VatRecipeManager.getInstance().loadRecipesFromConfig();
        EnchanterRecipeManager.getInstance().loadRecipesFromConfig();
        FarmersRegistry.addFarmers();
        SoulBinderRecipeManager.getInstance().addDefaultRecipes();
        PaintSourceValidator.instance.loadConfig();
        if (Fluids.fluidXpJuice == null) {
            fluids.forgeRegisterXPJuice();
        }
        if (Config.dumpMobNames) {
            this.dumpMobNamesToFile();
        }
        this.addModIntegration();
        TicProxy.init(event);
        proxy.init(event);
        Celeb.create();
        Scheduler.instance.start();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.processImc((ImmutableList<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)this));
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        ServerChannelRegister.load();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        ServerChannelRegister.store();
        ConduitNetworkTickHandler.instance.flush();
    }

    @Mod.EventHandler
    public void onImc(FMLInterModComms.IMCEvent evt) {
        this.processImc((ImmutableList<FMLInterModComms.IMCMessage>)evt.getMessages());
    }

    private void addModIntegration() {
        BuildcraftIntegration.init();
        TEIntegration.init();
    }

    private void processImc(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage msg : messages) {
            String key = msg.key;
            try {
                if (msg.isStringMessage()) {
                    String value = msg.getStringValue();
                    if ("recipe:vat".equals(key)) {
                        VatRecipeManager.getInstance().addCustomRecipes(value);
                        continue;
                    }
                    if ("recipe:sagmill".equals(key)) {
                        SagMillRecipeManager.getInstance().addCustomRecipes(value);
                        continue;
                    }
                    if ("recipe:alloysmelter".equals(key)) {
                        AlloyRecipeManager.getInstance().addCustomRecipes(value);
                        continue;
                    }
                    if ("poweredSpawner:blacklist:add".equals(key)) {
                        PoweredSpawnerConfig.getInstance().addToBlacklist(value);
                        continue;
                    }
                    if ("teleport:blacklist:add".equals(key)) {
                        Things.TRAVEL_BLACKLIST.add(value);
                        continue;
                    }
                    if ("soulVial:blacklist:add".equals(key) && ModObject.itemSoulVessel.getItem() != null) {
                        CapturedMob.addToBlackList(value);
                        continue;
                    }
                    if ("soulVial:unspawnablelist:add".equals(key)) {
                        CapturedMob.addToUnspawnableList(value);
                        continue;
                    }
                    if ("recipe:enchanter".equals(key)) {
                        EnchanterRecipeManager.getInstance().addCustomRecipes(value);
                        continue;
                    }
                    if (!"recipe:slicensplice".equals(key)) continue;
                    SliceAndSpliceRecipeManager.getInstance().addCustomRecipes(key);
                    continue;
                }
                if (msg.isNBTMessage()) {
                    if ("recipe:soulbinder".equals(key)) {
                        SoulBinderRecipeManager.getInstance().addRecipeFromNBT(msg.getNBTValue());
                        continue;
                    }
                    if ("poweredSpawner:costMultiplier".equals(key)) {
                        PoweredSpawnerConfig.getInstance().addEntityCostFromNBT(msg.getNBTValue());
                        continue;
                    }
                    if ("fluidFuel:add".equals(key)) {
                        FluidFuelRegister.instance.addFuel(msg.getNBTValue());
                        continue;
                    }
                    if ("fluidCoolant:add".equals(key)) {
                        FluidFuelRegister.instance.addCoolant(msg.getNBTValue());
                        continue;
                    }
                    if (!"redstone:connectable:add".equals(key)) continue;
                    InsulatedRedstoneConduit.addConnectableBlock(msg.getNBTValue());
                    continue;
                }
                if (!msg.isItemStackMessage()) continue;
                if ("painter:whitelist:add".equals(key)) {
                    PaintSourceValidator.instance.addToWhitelist(msg.getItemStackValue());
                    continue;
                }
                if (!"painter:blacklist:add".equals(key)) continue;
                PaintSourceValidator.instance.addToBlacklist(msg.getItemStackValue());
            }
            catch (Exception e) {
                Log.error("Error occured handling IMC message " + key + " from " + msg.getSender());
            }
        }
    }

    private void dumpMobNamesToFile() {
        File dumpFile = new File(Config.configDirectory, "mobTypes.txt");
        List names = EntityUtil.getAllRegisteredMobNames();
        try {
            BufferedWriter br = new BufferedWriter(new FileWriter(dumpFile, false));
            for (String name : names) {
                br.append(name);
                br.newLine();
            }
            br.flush();
            br.close();
        }
        catch (Exception e) {
            Log.error("Could not write mob types file: " + e);
        }
    }

    @Mod.EventHandler
    public static void handleMappings(FMLMissingMappingsEvent event) {
        MigrationMapper.handleMappings(event);
    }

    static {
        packetPipeline = new PacketHandler();
        lang = new Lang("enderio");
        CapInjectHandler.loadClass();
    }
}

