/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import openmods.reflection.FieldAccess;

public class RecipeUtils {
    private static FieldAccess<Integer> shapedOreRecipeWidth = FieldAccess.create(ShapedOreRecipe.class, "width");
    private static FieldAccess<Integer> shapedOreRecipeHeight = FieldAccess.create(ShapedOreRecipe.class, "height");

    public static List<IRecipe> getVanillaRecipes() {
        return CraftingManager.func_77594_a().func_77592_b();
    }

    public static IRecipe getFirstRecipeForItemStack(ItemStack resultingItem) {
        for (IRecipe recipe : RecipeUtils.getVanillaRecipes()) {
            ItemStack result;
            if (recipe == null || (result = recipe.func_77571_b()) == null || !result.func_77969_a(resultingItem)) continue;
            return recipe;
        }
        return null;
    }

    private static void addOreRecipeEntry(InputBuilder builder, int slot, Object value) {
        if (value instanceof ItemStack) {
            builder.add(slot, (ItemStack)value);
        } else if (value instanceof Collection) {
            builder.add(slot, (Collection)value);
        }
    }

    public static ItemStack[][] getFullRecipeInput(IRecipe recipe) {
        if (recipe instanceof ShapelessOreRecipe) {
            return RecipeUtils.getFullRecipeInput((ShapelessOreRecipe)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return RecipeUtils.getFullRecipeInput((ShapedOreRecipe)recipe);
        }
        if (recipe instanceof ShapedRecipes) {
            return RecipeUtils.getFullRecipeInput((ShapedRecipes)recipe);
        }
        if (recipe instanceof ShapelessRecipes) {
            return RecipeUtils.getFullRecipeInput((ShapelessRecipes)recipe);
        }
        return null;
    }

    public static ItemStack[][] getFullRecipeInput(ShapelessOreRecipe recipe) {
        ArrayList inputs = recipe.getInput();
        int size = inputs.size();
        InputBuilder builder = new InputBuilder();
        for (int i = 0; i < size; ++i) {
            Object input = inputs.get(i);
            RecipeUtils.addOreRecipeEntry(builder, i, input);
        }
        return builder.build(size);
    }

    public static ItemStack[][] getFullRecipeInput(ShapedOreRecipe recipe) {
        InputBuilder builder = new InputBuilder();
        int width = shapedOreRecipeWidth.get(recipe);
        int height = shapedOreRecipeHeight.get(recipe);
        Object[] input = recipe.getInput();
        int inputIndex = 0;
        for (int row = 0; row < height; ++row) {
            for (int column = 0; column < width; ++column) {
                int outputIndex = row * 3 + column;
                RecipeUtils.addOreRecipeEntry(builder, outputIndex, input[inputIndex]);
                ++inputIndex;
            }
        }
        return builder.build(9);
    }

    public static ItemStack[][] getFullRecipeInput(ShapedRecipes recipe) {
        InputBuilder builder = new InputBuilder();
        ItemStack[] input = recipe.field_77574_d;
        int inputIndex = 0;
        for (int row = 0; row < recipe.field_77577_c; ++row) {
            for (int column = 0; column < recipe.field_77576_b; ++column) {
                int outputIndex = row * 3 + column;
                builder.add(outputIndex, input[inputIndex]);
                ++inputIndex;
            }
        }
        return builder.build(9);
    }

    public static ItemStack[][] getFullRecipeInput(ShapelessRecipes recipe) {
        InputBuilder builder = new InputBuilder();
        List input = recipe.field_77579_b;
        int size = recipe.func_77570_a();
        for (int i = 0; i < size; ++i) {
            builder.add(i, (ItemStack)input.get(i));
        }
        return builder.build(size);
    }

    public static class InputBuilder {
        private static final ItemStack[] EMPTY_SLOT = new ItemStack[0];
        private final Map<Integer, List<ItemStack>> slots = Maps.newHashMap();

        private List<ItemStack> getSlot(int slot) {
            ArrayList result = this.slots.get(slot);
            if (result == null) {
                result = Lists.newArrayList();
                this.slots.put(slot, result);
            }
            return result;
        }

        private static void addItemStack(List<ItemStack> slot, ItemStack stack) {
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                Item item = stack.func_77973_b();
                item.func_150895_a(item, null, slot);
            } else {
                slot.add(stack.func_77946_l());
            }
        }

        public void add(int slot, ItemStack stack) {
            if (stack != null) {
                List<ItemStack> slotContents = this.getSlot(slot);
                InputBuilder.addItemStack(slotContents, stack);
            }
        }

        public void add(int slot, ItemStack[] stacks) {
            List<ItemStack> slotContents = this.getSlot(slot);
            for (ItemStack stack : stacks) {
                if (stack == null) continue;
                InputBuilder.addItemStack(slotContents, stack);
            }
        }

        public void add(int slot, Collection<ItemStack> stacks) {
            List<ItemStack> slotContents = this.getSlot(slot);
            for (ItemStack stack : stacks) {
                if (stack == null) continue;
                InputBuilder.addItemStack(slotContents, stack);
            }
        }

        public ItemStack[][] build(int slotCount) {
            ItemStack[][] result = new ItemStack[slotCount][];
            for (int i = 0; i < slotCount; ++i) {
                List<ItemStack> slot = this.slots.get(i);
                result[i] = slot != null ? slot.toArray(new ItemStack[slot.size()]) : EMPTY_SLOT;
            }
            return result;
        }
    }
}

