/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class ModIdentifier {
    public static final ModIdentifier INSTANCE = new ModIdentifier();
    private final Map<Item, ModContainer> itemCache = Maps.newHashMap();
    private final Map<Block, ModContainer> blockCache = Maps.newHashMap();

    public ModContainer getModItemStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item == null) {
            return null;
        }
        return this.getModForItem(item);
    }

    public ModContainer getModForItem(Item item) {
        if (this.itemCache.containsKey(item)) {
            return this.itemCache.get(item);
        }
        ModContainer result = ModIdentifier.identifyItem(item);
        this.itemCache.put(item, result);
        return result;
    }

    public ModContainer getModForBlock(Block block) {
        if (this.blockCache.containsKey(block)) {
            return this.blockCache.get(block);
        }
        ModContainer result = ModIdentifier.identifyBlock(block);
        this.blockCache.put(block, result);
        return result;
    }

    private static ModContainer identifyBlock(Block block) {
        ResourceLocation id = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        return ModIdentifier.findModContainer(id);
    }

    private static ModContainer identifyItem(Item item) {
        ResourceLocation id = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item);
        return ModIdentifier.findModContainer(id);
    }

    private static ModContainer findModContainer(ResourceLocation id) {
        if (id == null) {
            return null;
        }
        String modId = id.func_110624_b();
        return (ModContainer)Loader.instance().getIndexedModList().get(modId);
    }
}

