/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InventoryUtils {
    public static boolean areItemAndTagEqual(ItemStack stackA, ItemStack stackB) {
        return stackA.func_77969_a(stackB) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean areMergeCandidates(ItemStack source, ItemStack target) {
        return InventoryUtils.areItemAndTagEqual(source, target) && target.field_77994_a < target.func_77976_d();
    }

    public static ItemStack copyAndChange(ItemStack stack, int newSize) {
        ItemStack copy = stack.func_77946_l();
        copy.field_77994_a = newSize;
        return copy;
    }

    public static List<ItemStack> getInventoryContents(IInventory inventory) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null) continue;
            result.add(slot);
        }
        return result;
    }

    public static boolean tryMergeStacks(ItemStack stackToMerge, ItemStack stackInSlot) {
        if (stackInSlot == null || !stackInSlot.func_77969_a(stackToMerge) || !ItemStack.func_77970_a((ItemStack)stackToMerge, (ItemStack)stackInSlot)) {
            return false;
        }
        int newStackSize = stackInSlot.field_77994_a + stackToMerge.field_77994_a;
        int maxStackSize = stackToMerge.func_77976_d();
        if (newStackSize <= maxStackSize) {
            stackToMerge.field_77994_a = 0;
            stackInSlot.field_77994_a = newStackSize;
            return true;
        }
        if (stackInSlot.field_77994_a < maxStackSize) {
            stackToMerge.field_77994_a -= maxStackSize - stackInSlot.field_77994_a;
            stackInSlot.field_77994_a = maxStackSize;
            return true;
        }
        return false;
    }

    public static ItemStack returnItem(ItemStack stack) {
        return stack == null || stack.field_77994_a <= 0 ? null : stack.func_77946_l();
    }

    protected static void isItemValid(IInventory inventory, int slot, ItemStack stack) {
        Preconditions.checkArgument((boolean)inventory.func_94041_b(slot, stack), (String)"Slot %s cannot accept item", (Object[])new Object[]{slot});
    }

    public static Iterable<ItemStack> asIterable(final IInventory inv) {
        return new Iterable<ItemStack>(){

            @Override
            public Iterator<ItemStack> iterator() {
                return new AbstractIterator<ItemStack>(){
                    final int size;
                    int slot;
                    {
                        this.size = inv.func_70302_i_();
                        this.slot = 0;
                    }

                    protected ItemStack computeNext() {
                        if (this.slot >= this.size) {
                            return (ItemStack)this.endOfData();
                        }
                        return inv.func_70301_a(this.slot++);
                    }
                };
            }
        };
    }

    public static IItemHandler tryGetHandler(World world, BlockPos pos, EnumFacing side) {
        if (!world.func_175667_e(pos)) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        return InventoryUtils.tryGetHandler(te, side);
    }

    public static IItemHandler tryGetHandler(TileEntity te, EnumFacing side) {
        if (te == null) {
            return null;
        }
        if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        if (te instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)te, side);
        }
        if (te instanceof IInventory) {
            return new InvWrapper((IInventory)te);
        }
        return null;
    }

    public static boolean canInsertStack(IItemHandler handler, ItemStack stack) {
        ItemStack toInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)true);
        return toInsert == null || toInsert.field_77994_a < stack.field_77994_a;
    }
}

