/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.RegistryBuilder;
import openmods.OpenMods;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableObjectType;
import openmods.utils.CommonRegistryCallbacks;
import openmods.utils.RegistrationContextBase;

@Mod.EventBusSubscriber
public class SyncableObjectTypeRegistry {
    private static IForgeRegistry<SyncableObjectType> REGISTRY;

    @SubscribeEvent
    public static void registerRegistry(RegistryEvent.NewRegistry e) {
        REGISTRY = new RegistryBuilder().addCallback((Object)new Callbacks()).setIDRange(0, 65535).setType(SyncableObjectType.class).setName(OpenMods.location("syncable_object_type")).create();
    }

    public static SyncableObjectType getType(int typeId) {
        return (SyncableObjectType)CommonRegistryCallbacks.getEntryIdMap(REGISTRY).inverse().get((Object)typeId);
    }

    public static int getTypeId(SyncableObjectType type) {
        return (Integer)CommonRegistryCallbacks.getEntryIdMap(REGISTRY).get((Object)type);
    }

    public static SyncableObjectType getType(Class<? extends ISyncableObject> cls) {
        Map objectToEntryMap = CommonRegistryCallbacks.getObjectToEntryMap(REGISTRY);
        return objectToEntryMap.get(cls);
    }

    public static RegistrationContext startRegistration(IForgeRegistry<SyncableObjectType> registry) {
        return new RegistrationContext(registry);
    }

    public static RegistrationContext startRegistration(IForgeRegistry<SyncableObjectType> registry, String domain) {
        return new RegistrationContext(registry, domain);
    }

    public static class RegistrationContext
    extends RegistrationContextBase<SyncableObjectType> {
        public RegistrationContext(IForgeRegistry<SyncableObjectType> registry, String domain) {
            super(registry, domain);
        }

        public RegistrationContext(IForgeRegistry<SyncableObjectType> registry) {
            super(registry);
        }

        public RegistrationContext register(Class<? extends ISyncableObject> cls) {
            Constructor<? extends ISyncableObject> ctor;
            Preconditions.checkState((!Modifier.isAbstract(cls.getModifiers()) ? 1 : 0) != 0, (String)"Class %s is abstract", (Object[])new Object[]{cls});
            try {
                ctor = cls.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Class " + cls + " has no parameterless constructor");
            }
            return this.register(cls, new Supplier<ISyncableObject>(){

                public ISyncableObject get() {
                    try {
                        return (ISyncableObject)ctor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            });
        }

        public RegistrationContext register(final Class<? extends ISyncableObject> cls, final Supplier<ISyncableObject> supplier) {
            ResourceLocation typeId = new ResourceLocation(this.domain, cls.getName());
            this.registry.register((IForgeRegistryEntry)new SyncableObjectType(){

                @Override
                public Class<? extends ISyncableObject> getObjectClass() {
                    return cls;
                }

                @Override
                public ISyncableObject createDummyObject() {
                    return (ISyncableObject)supplier.get();
                }

                public String toString() {
                    return "Wrapper{" + cls + "}";
                }
            }.setRegistryName(typeId));
            return this;
        }
    }

    private static class Callbacks
    extends CommonRegistryCallbacks<Class<? extends ISyncableObject>, SyncableObjectType> {
        private Callbacks() {
        }

        @Override
        protected Class<? extends ISyncableObject> getWrappedObject(SyncableObjectType entry) {
            return entry.getObjectClass();
        }
    }
}

