/*
 * Decompiled with CFR 0.152.
 */
package openmods.serializable;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import openmods.reflection.ConstructorAccess;
import openmods.reflection.TypeUtils;
import openmods.serializable.IGenericSerializerProvider;
import openmods.serializable.IInstanceFactory;
import openmods.serializable.ISerializerProvider;
import openmods.serializable.IStreamReadable;
import openmods.serializable.IStreamWriteable;
import openmods.serializable.SerializerAdapters;
import openmods.serializable.providers.ArraySerializerProvider;
import openmods.serializable.providers.ClassSerializerProvider;
import openmods.serializable.providers.EnumSerializerProvider;
import openmods.serializable.providers.ListSerializerProvider;
import openmods.serializable.providers.MapSerializerProvider;
import openmods.serializable.providers.SetSerializerProvider;
import openmods.utils.io.IStreamReader;
import openmods.utils.io.IStreamSerializer;
import openmods.utils.io.TypeRW;

public class SerializerRegistry {
    public static final SerializerRegistry instance = new SerializerRegistry();
    private final Map<Class<?>, IStreamSerializer<?>> serializers = Maps.newHashMap(TypeRW.STREAM_SERIALIZERS);
    private final List<ISerializerProvider> providers = Lists.newArrayList();
    private final List<IGenericSerializerProvider> genericProviders = Lists.newArrayList();

    public SerializerRegistry() {
        this.providers.add(new EnumSerializerProvider());
        this.providers.add(new ArraySerializerProvider());
        this.providers.add(new ClassSerializerProvider());
        this.genericProviders.add(new ListSerializerProvider());
        this.genericProviders.add(new SetSerializerProvider());
        this.genericProviders.add(new MapSerializerProvider());
    }

    private static <T> Class<? extends T> resolve(Class<?> intf, Class<?> concrete) {
        Class rawType = TypeUtils.getTypeParameter(intf, concrete).getRawType();
        return rawType;
    }

    public <T> void register(Class<? extends T> target, IStreamSerializer<T> serializer) {
        Preconditions.checkArgument((target != Object.class ? 1 : 0) != 0, (Object)"Can't register serializer for Object");
        IStreamSerializer<T> prev = this.serializers.put(target, serializer);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate serializer for %s", (Object[])new Object[]{target});
    }

    public <T> void register(IStreamSerializer<T> serializer) {
        Class<T> cls = SerializerRegistry.resolve(IStreamSerializer.class, serializer.getClass());
        this.register(cls, serializer);
    }

    public <T extends IStreamWriteable & IStreamReadable> void registerSerializable(Class<? extends T> cls, IInstanceFactory<T> factory) {
        this.register(cls, SerializerAdapters.createFromFactory(factory));
    }

    public <T extends IStreamWriteable & IStreamReadable> void registerSerializable(IInstanceFactory<T> factory) {
        Class<T> cls = SerializerRegistry.resolve(IInstanceFactory.class, factory.getClass());
        this.registerSerializable(cls, factory);
    }

    public <T extends IStreamWriteable & IStreamReadable> void registerSerializable(Class<T> cls) {
        ConstructorAccess<T> factory = ConstructorAccess.create(cls);
        this.registerSerializable(cls, factory);
    }

    public <T extends IStreamWriteable> void registerWriteable(Class<? extends T> cls, IStreamReader<T> reader) {
        this.register(cls, SerializerAdapters.createFromReader(reader));
    }

    public <T extends IStreamWriteable> void registerWriteable(IStreamReader<T> reader) {
        Class<T> cls = SerializerRegistry.resolve(IStreamReader.class, reader.getClass());
        this.registerWriteable(cls, reader);
    }

    public void registerProvider(ISerializerProvider provider) {
        Preconditions.checkNotNull((Object)provider);
        this.providers.add(provider);
    }

    private IStreamSerializer<?> findClassSerializer(Class<?> cls, IStreamSerializer<?> serializer) {
        for (ISerializerProvider provider : this.providers) {
            serializer = provider.getSerializer(cls);
            if (serializer == null) continue;
            this.serializers.put(cls, serializer);
            return serializer;
        }
        return null;
    }

    public <T> IStreamSerializer<T> findSerializer(Class<? extends T> cls) {
        IStreamSerializer<?> serializer = this.serializers.get(cls);
        if (serializer == null) {
            serializer = this.findClassSerializer(cls, serializer);
        }
        return serializer;
    }

    public IStreamSerializer<Object> findSerializer(Type type) {
        if (type instanceof Class) {
            return this.findSerializer((Class)type);
        }
        return this.findGenericSerializer(type);
    }

    protected IStreamSerializer<Object> findGenericSerializer(Type type) {
        for (IGenericSerializerProvider provider : this.genericProviders) {
            IStreamSerializer<Object> serializer = provider.getSerializer(type);
            if (serializer == null) continue;
            return serializer;
        }
        return null;
    }

    public <T> T createFromStream(PacketBuffer input, Class<? extends T> cls) throws IOException {
        IStreamSerializer<T> reader = this.findSerializer(cls);
        Preconditions.checkNotNull(reader, (String)"Can't find reader for %s", (Object[])new Object[]{cls});
        return reader.readFromStream(input);
    }

    public Object createFromStream(PacketBuffer input, Type type) throws IOException {
        IStreamSerializer<Object> reader = this.findSerializer(type);
        Preconditions.checkNotNull(reader, (String)"Can't find reader for %s", (Object[])new Object[]{type});
        return reader.readFromStream(input);
    }

    public <T> void writeToStream(PacketBuffer output, Class<? extends T> cls, T target) throws IOException {
        Preconditions.checkNotNull(target);
        IStreamSerializer<T> writer = this.findSerializer(cls);
        Preconditions.checkNotNull(writer, (String)"Can't find writer for %s", (Object[])new Object[]{cls});
        writer.writeToStream(target, output);
    }

    public void writeToStream(PacketBuffer output, Type type, Object target) throws IOException {
        Preconditions.checkNotNull((Object)target);
        IStreamSerializer<Object> writer = this.findSerializer(type);
        Preconditions.checkNotNull(writer, (String)"Can't find writer for %s", (Object[])new Object[]{type});
        writer.writeToStream(target, output);
    }
}

