/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import openmods.Log;
import openmods.reflection.TypeVariableHolder;
import org.objectweb.asm.Type;

public class TypeVariableHolderHandler {
    private static final Type USE_DECLARING_TYPE_MARKER = Type.getType(TypeVariableHolder.UseDeclaringType.class);
    private final Map<Class<?>, Map<String, TypeVariable<?>>> sourceCache = Maps.newHashMap();

    public void fillAllHolders(ASMDataTable data) {
        HashMap classTargetToSource = Maps.newHashMap();
        HashMap fieldTargetToSource = Maps.newHashMap();
        for (ASMDataTable.ASMData target : data.getAll(TypeVariableHolder.class.getName())) {
            TypeVariableHolderHandler.findTargets(target, classTargetToSource, fieldTargetToSource);
        }
        this.fillFields(classTargetToSource, fieldTargetToSource);
    }

    public static void initializeClass(Class<?> targetClass) {
        new TypeVariableHolderHandler().fillHolders(targetClass);
    }

    public void fillHolders(Class<?> targetClass) {
        HashMap targetToSource = Maps.newHashMap();
        TypeVariableHolderHandler.fillHolders(targetClass, targetToSource);
        for (Class<?> inner : targetClass.getDeclaredClasses()) {
            TypeVariableHolderHandler.fillHolders(inner, targetToSource);
        }
        this.fillFields(targetToSource);
    }

    private static void fillHolders(Class<?> targetClass, Map<Field, Class<?>> targetToSource) {
        Field[] fields = targetClass.getDeclaredFields();
        TypeVariableHolder clsAnnotation = targetClass.getAnnotation(TypeVariableHolder.class);
        if (clsAnnotation != null) {
            Class<?> sourceClass = TypeVariableHolderHandler.findSourceClass(clsAnnotation, targetClass);
            Field[] fieldArray = fields;
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field f = fieldArray[i];
                if (!TypeVariableHolderHandler.isValidField(f)) continue;
                targetToSource.put(f, sourceClass);
            }
        }
        for (Field f : fields) {
            TypeVariableHolder fieldAnnotation = f.getAnnotation(TypeVariableHolder.class);
            if (fieldAnnotation == null) continue;
            Preconditions.checkArgument((boolean)TypeVariableHolderHandler.isValidField(f), (String)"Field %s marked with TypeVariableHolder annotation must be static, non-final and have TypeVariable type", (Object[])new Object[]{f});
            Class<?> sourceClass = TypeVariableHolderHandler.findSourceClass(fieldAnnotation, targetClass);
            targetToSource.put(f, sourceClass);
        }
    }

    private static Class<?> findSourceClass(TypeVariableHolder annotation, Class<?> targetClass) {
        if (annotation.value() == TypeVariableHolder.UseDeclaringType.class) {
            return targetClass;
        }
        return annotation.value();
    }

    private static void findTargets(ASMDataTable.ASMData target, Map<Field, Class<?>> classTargetToSource, Map<Field, Class<?>> fieldTargetToSource) {
        String targetClassName = target.getClassName();
        String targetObject = target.getObjectName();
        Type sourceClassName = (Type)target.getAnnotationInfo().get("value");
        try {
            Class<?> targetClass = Class.forName(targetClassName);
            Class<?> sourceClass = sourceClassName == null || sourceClassName.equals((Object)USE_DECLARING_TYPE_MARKER) ? targetClass : Class.forName(sourceClassName.getClassName());
            if (targetClassName.equals(targetObject)) {
                TypeVariableHolderHandler.addClassFields(classTargetToSource, targetClass, sourceClass);
            } else {
                TypeVariableHolderHandler.addField(fieldTargetToSource, targetClass, targetObject, sourceClass);
            }
        }
        catch (Exception e) {
            Log.warn(e, "Failed to fill type variable holder at %s:%s", targetClassName, targetObject);
        }
    }

    private static boolean isValidField(Field field) {
        int modifiers = field.getModifiers();
        return field.getType() == TypeVariable.class && Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers);
    }

    private static void addField(Map<Field, Class<?>> fieldTargetToSource, Class<?> targetClass, String fieldName, Class<?> sourceClass) throws Exception {
        Field f = targetClass.getDeclaredField(fieldName);
        Preconditions.checkArgument((boolean)TypeVariableHolderHandler.isValidField(f), (String)"Field %s marked with TypeVariableHolder annotation must be static, non-final and have TypeVariable type", (Object[])new Object[]{f});
        fieldTargetToSource.put(f, sourceClass);
    }

    private static void addClassFields(Map<Field, Class<?>> classTargetToSource, Class<?> targetClass, Class<?> sourceClass) {
        for (Field f : targetClass.getDeclaredFields()) {
            if (!TypeVariableHolderHandler.isValidField(f)) continue;
            classTargetToSource.put(f, sourceClass);
        }
    }

    private void fillFields(Map<Field, Class<?>> classTargetToSource, Map<Field, Class<?>> fieldTargetToSource) {
        HashMap targetToSource = Maps.newHashMap(classTargetToSource);
        targetToSource.putAll(fieldTargetToSource);
        this.fillFields(targetToSource);
    }

    private void fillFields(Map<Field, Class<?>> fieldTargetToSource) {
        for (Map.Entry<Field, Class<?>> e : fieldTargetToSource.entrySet()) {
            this.fillField(e.getKey(), e.getValue());
        }
    }

    private void fillField(Field targetField, Class<?> sourceClass) {
        try {
            Map<String, TypeVariable<?>> sourceVariables = this.getSourceTypeVariables(sourceClass);
            String variableName = targetField.getName();
            TypeVariable<?> sourceTypeVariable = sourceVariables.get(variableName);
            Preconditions.checkState((sourceTypeVariable != null ? 1 : 0) != 0, (String)"Can't find type variable '%s' in class '%s", (Object[])new Object[]{variableName, sourceClass});
            targetField.setAccessible(true);
            targetField.set(null, sourceTypeVariable);
        }
        catch (Exception e) {
            Log.warn(e, "Failed to set field %s", targetField);
        }
    }

    private Map<String, TypeVariable<?>> getSourceTypeVariables(Class<?> sourceClass) {
        HashMap result = this.sourceCache.get(sourceClass);
        if (result == null) {
            result = Maps.newHashMap();
            for (TypeVariable<Class<?>> t : sourceClass.getTypeParameters()) {
                result.put(t.getName(), t);
            }
            this.sourceCache.put(sourceClass, result);
        }
        return result;
    }
}

