/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import openmods.reflection.ReflectionHelper;
import openmods.reflection.TypeVariableHolder;

public class MethodAccess {
    private static List<ArgResolver> resolvers;

    public static <R> Function0<R> create(Class<? extends R> returnCls, Class<?> target, String ... names) {
        return new Function0Impl<R>(returnCls, ReflectionHelper.getMethod(target, names, new Class[0]));
    }

    public static <R, P1> Function1<R, P1> create(Class<? extends R> returnCls, Class<?> target, Class<? extends P1> p1, String ... names) {
        return new Function1Impl(returnCls, ReflectionHelper.getMethod(target, names, p1));
    }

    public static <R, P1, P2> Function2<R, P1, P2> create(Class<? extends R> returnCls, Class<?> target, Class<? extends P1> p1, Class<? extends P2> p2, String ... names) {
        return new Function2Impl(returnCls, ReflectionHelper.getMethod(target, names, p1, p2));
    }

    public static <R, P1, P2, P3> Function3<R, P1, P2, P3> create(Class<? extends R> returnCls, Class<?> target, Class<? extends P1> p1, Class<? extends P2> p2, Class<? extends P3> p3, String ... names) {
        return new Function3Impl(returnCls, ReflectionHelper.getMethod(target, names, p1, p2, p3));
    }

    public static <R, P1, P2, P3, P4> Function4<R, P1, P2, P3, P4> create(Class<? extends R> returnCls, Class<?> target, Class<? extends P1> p1, Class<? extends P2> p2, Class<? extends P3> p3, Class<? extends P4> p4, String ... names) {
        return new Function4Impl(returnCls, ReflectionHelper.getMethod(target, names, p1, p2, p3, p4));
    }

    public static <R, P1, P2, P3, P4, P5> Function5<R, P1, P2, P3, P4, P5> create(Class<? extends R> returnCls, Class<?> target, Class<? extends P1> p1, Class<? extends P2> p2, Class<? extends P3> p3, Class<? extends P4> p4, Class<? extends P5> p5, String ... names) {
        return new Function5Impl(returnCls, ReflectionHelper.getMethod(target, names, p1, p2, p3, p4, p5));
    }

    public static <T> Class<T> resolveReturnType(Class<? extends FunctionBase<T>> cls) {
        TypeToken type = TypeToken.of(cls);
        return type.resolveType(TypeVariableHolders.FunctionBaseHolder.R).getRawType();
    }

    public static Class<?>[] resolveParameterTypes(Class<? extends FunctionBase<?>> cls) {
        if (resolvers == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)new ArgResolver(Function0.class, TypeVariableHolders.Function0Holder.args()));
            builder.add((Object)new ArgResolver(Function1.class, TypeVariableHolders.Function1Holder.args()));
            builder.add((Object)new ArgResolver(Function2.class, TypeVariableHolders.Function2Holder.args()));
            builder.add((Object)new ArgResolver(Function3.class, TypeVariableHolders.Function3Holder.args()));
            builder.add((Object)new ArgResolver(Function4.class, TypeVariableHolders.Function4Holder.args()));
            builder.add((Object)new ArgResolver(Function5.class, TypeVariableHolders.Function5Holder.args()));
            resolvers = builder.build();
        }
        ArrayList applicableResolvers = Lists.newArrayListWithCapacity((int)resolvers.size());
        for (ArgResolver r : resolvers) {
            if (!r.canResolve(cls)) continue;
            applicableResolvers.add(r);
        }
        Preconditions.checkArgument((!applicableResolvers.isEmpty() ? 1 : 0) != 0, (String)"Invalid type: %s", (Object[])new Object[]{cls});
        Preconditions.checkArgument((applicableResolvers.size() == 1 ? 1 : 0) != 0, (String)"Ambiguous type: %s, bases: ", (Object[])new Object[]{cls, Lists.transform((List)applicableResolvers, (Function)new Function<ArgResolver, String>(){

            public String apply(ArgResolver input) {
                return input.intf.getName();
            }
        })});
        return ((ArgResolver)applicableResolvers.get(0)).resolve(cls);
    }

    private static class ArgResolver {
        private final Class<?> intf;
        private final TypeVariable<?>[] args;

        public ArgResolver(Class<?> intf, TypeVariable<?> ... args) {
            this.intf = intf;
            this.args = args;
        }

        public boolean canResolve(Class<?> cls) {
            return this.intf.isAssignableFrom(cls);
        }

        public Class<?>[] resolve(Class<?> cls) {
            TypeToken type = TypeToken.of(cls);
            Class[] result = new Class[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                result[i] = type.resolveType(this.args[i]).getRawType();
            }
            return result;
        }
    }

    public static class TypeVariableHolders {

        @TypeVariableHolder(value=Function5.class)
        public static class Function5Holder {
            public static TypeVariable<?> R;
            public static TypeVariable<?> P1;
            public static TypeVariable<?> P2;
            public static TypeVariable<?> P3;
            public static TypeVariable<?> P4;
            public static TypeVariable<?> P5;

            public static TypeVariable<?>[] args() {
                return new TypeVariable[]{P1, P2, P3, P4, P5};
            }
        }

        @TypeVariableHolder(value=Function4.class)
        public static class Function4Holder {
            public static TypeVariable<?> R;
            public static TypeVariable<?> P1;
            public static TypeVariable<?> P2;
            public static TypeVariable<?> P3;
            public static TypeVariable<?> P4;

            public static TypeVariable<?>[] args() {
                return new TypeVariable[]{P1, P2, P3, P4};
            }
        }

        @TypeVariableHolder(value=Function3.class)
        public static class Function3Holder {
            public static TypeVariable<?> R;
            public static TypeVariable<?> P1;
            public static TypeVariable<?> P2;
            public static TypeVariable<?> P3;

            public static TypeVariable<?>[] args() {
                return new TypeVariable[]{P1, P2, P3};
            }
        }

        @TypeVariableHolder(value=Function2.class)
        public static class Function2Holder {
            public static TypeVariable<?> R;
            public static TypeVariable<?> P1;
            public static TypeVariable<?> P2;

            public static TypeVariable<?>[] args() {
                return new TypeVariable[]{P1, P2};
            }
        }

        @TypeVariableHolder(value=Function1.class)
        public static class Function1Holder {
            public static TypeVariable<?> R;
            public static TypeVariable<?> P1;

            public static TypeVariable<?>[] args() {
                return new TypeVariable[]{P1};
            }
        }

        @TypeVariableHolder(value=Function0.class)
        public static class Function0Holder {
            public static TypeVariable<?> R;

            public static TypeVariable<?>[] args() {
                return new TypeVariable[0];
            }
        }

        @TypeVariableHolder(value=FunctionVar.class)
        public static class FunctionVarHolder {
            public static TypeVariable<?> R;

            public static TypeVariable<?>[] args() {
                return new TypeVariable[0];
            }
        }

        @TypeVariableHolder(value=FunctionBase.class)
        public static class FunctionBaseHolder {
            public static TypeVariable<?> R;

            public static TypeVariable<?>[] args() {
                return new TypeVariable[0];
            }
        }
    }

    private static class Function5Impl<R, P1, P2, P3, P4, P5>
    extends FunctionWrap<R>
    implements Function5<R, P1, P2, P3, P4, P5> {
        public Function5Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target, P1 p1, P2 p2, P3 p3, P4 p4, P5 p5) {
            return super.call(target, p1, p2, p3, p4, p5);
        }
    }

    public static interface Function5<R, P1, P2, P3, P4, P5>
    extends FunctionBase<R> {
        public R call(Object var1, P1 var2, P2 var3, P3 var4, P4 var5, P5 var6);
    }

    private static class Function4Impl<R, P1, P2, P3, P4>
    extends FunctionWrap<R>
    implements Function4<R, P1, P2, P3, P4> {
        public Function4Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target, P1 p1, P2 p2, P3 p3, P4 p4) {
            return super.call(target, p1, p2, p3, p4);
        }
    }

    public static interface Function4<R, P1, P2, P3, P4>
    extends FunctionBase<R> {
        public R call(Object var1, P1 var2, P2 var3, P3 var4, P4 var5);
    }

    private static class Function3Impl<R, P1, P2, P3>
    extends FunctionWrap<R>
    implements Function3<R, P1, P2, P3> {
        public Function3Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target, P1 p1, P2 p2, P3 p3) {
            return super.call(target, p1, p2, p3);
        }
    }

    public static interface Function3<R, P1, P2, P3>
    extends FunctionBase<R> {
        public R call(Object var1, P1 var2, P2 var3, P3 var4);
    }

    private static class Function2Impl<R, P1, P2>
    extends FunctionWrap<R>
    implements Function2<R, P1, P2> {
        public Function2Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target, P1 p1, P2 p2) {
            return super.call(target, p1, p2);
        }
    }

    public static interface Function2<R, P1, P2>
    extends FunctionBase<R> {
        public R call(Object var1, P1 var2, P2 var3);
    }

    private static class Function1Impl<R, P1>
    extends FunctionWrap<R>
    implements Function1<R, P1> {
        public Function1Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target, P1 p1) {
            return super.call(target, p1);
        }
    }

    public static interface Function1<R, P1>
    extends FunctionBase<R> {
        public R call(Object var1, P1 var2);
    }

    private static class Function0Impl<R>
    extends FunctionWrap<R>
    implements Function0<R> {
        public Function0Impl(Class<? extends R> returnCls, Method method) {
            super(returnCls, method);
        }

        @Override
        public R call(Object target) {
            return super.call(target, new Object[0]);
        }
    }

    public static interface Function0<R>
    extends FunctionBase<R> {
        public R call(Object var1);
    }

    private static class FunctionWrap<R>
    implements FunctionVar<R> {
        private final Method method;

        public FunctionWrap(Class<? extends R> returnCls, Method method) {
            this.method = method;
            method.setAccessible(true);
            Preconditions.checkArgument((boolean)returnCls.isAssignableFrom(method.getReturnType()), (String)"Method '%s' has invalid return type", (Object[])new Object[]{method});
        }

        @Override
        public R call(Object target, Object ... args) {
            try {
                return (R)this.method.invoke(target, args);
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
        }
    }

    public static interface FunctionVar<R>
    extends FunctionBase<R> {
        public R call(Object var1, Object ... var2);
    }

    public static interface FunctionBase<R> {
    }
}

