/*
 * Decompiled with CFR 0.152.
 */
package openmods.model.variant;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import openmods.model.BakedModelAdapter;
import openmods.model.ModelUpdater;
import openmods.model.variant.VariantModelData;
import openmods.model.variant.VariantModelState;

public class VariantModel
implements IModelCustomData {
    private static final String KEY_VARIANTS = "variants";
    private static final String KEY_EXPANSIONS = "expansions";
    private static final String KEY_BASE = "base";
    public static final VariantModel EMPTY_MODEL = new VariantModel((Optional<ResourceLocation>)Optional.absent(), new VariantModelData());
    private final Optional<ResourceLocation> base;
    private final VariantModelData modelData;

    public VariantModel(Optional<ResourceLocation> base, VariantModelData modelData) {
        this.base = base;
        this.modelData = modelData;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel baseModel;
        HashMap bakedSubModels = Maps.newHashMap();
        for (ResourceLocation subModel : this.modelData.getAllModels()) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)subModel, (String)("Couldn't load sub-model dependency: " + subModel));
            bakedSubModels.put(subModel, model.bake((IModelState)new ModelStateComposition(state, model.getDefaultState()), format, bakedTextureGetter));
        }
        if (this.base.isPresent()) {
            ResourceLocation baseLocation = (ResourceLocation)this.base.get();
            baseModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)baseLocation, (String)("Couldn't load base-model dependency: " + baseLocation));
        } else {
            baseModel = ModelLoaderRegistry.getMissingModel();
        }
        IBakedModel bakedBaseModel = baseModel.bake((IModelState)new ModelStateComposition(state, baseModel.getDefaultState()), format, bakedTextureGetter);
        return new BakedModel(bakedBaseModel, this.modelData, bakedSubModels, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ModelUpdater updater = new ModelUpdater((Map<String, String>)customData);
        Optional<ResourceLocation> base = updater.get(KEY_BASE, ModelUpdater.MODEL_LOCATION, this.base);
        VariantModelData modelData = this.modelData;
        if (customData.containsKey((Object)KEY_VARIANTS) || customData.containsKey((Object)KEY_EXPANSIONS)) {
            updater.markChanged();
            Optional variants = Optional.fromNullable((Object)customData.get((Object)KEY_VARIANTS));
            Optional expansions = Optional.fromNullable((Object)customData.get((Object)KEY_EXPANSIONS));
            modelData = modelData.update((Optional<String>)variants, (Optional<String>)expansions);
        }
        return updater.hasChanged() ? new VariantModel(base, modelData) : this;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf((Collection)Sets.union(this.modelData.getAllModels(), (Set)this.base.asSet()));
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    private static class BakedModel
    extends BakedModelAdapter {
        private final VariantModelData modelData;
        private final Map<ResourceLocation, IBakedModel> bakedSubModels;

        public BakedModel(IBakedModel base, VariantModelData modelData, Map<ResourceLocation, IBakedModel> bakedSubModels, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            super(base, cameraTransforms);
            this.modelData = modelData;
            this.bakedSubModels = bakedSubModels;
        }

        @Override
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            VariantModelState modelState = BakedModel.getModelSelectors(state);
            ArrayList result = Lists.newArrayList((Iterable)this.base.func_188616_a(state, side, rand));
            for (ResourceLocation subModel : this.modelData.getModels(modelState.getSelectors())) {
                IBakedModel bakedSubModel = this.bakedSubModels.get(subModel);
                result.addAll(bakedSubModel.func_188616_a(state, side, rand));
            }
            return result;
        }

        private static VariantModelState getModelSelectors(IBlockState state) {
            VariantModelState result;
            IExtendedBlockState extendedState;
            if (state instanceof IExtendedBlockState && (extendedState = (IExtendedBlockState)state).getUnlistedNames().contains(VariantModelState.PROPERTY) && (result = (VariantModelState)extendedState.getValue(VariantModelState.PROPERTY)) != null) {
                return result;
            }
            return VariantModelState.EMPTY;
        }

        @Override
        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

