/*
 * Decompiled with CFR 0.152.
 */
package openmods.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import openmods.model.BakedModelAdapter;
import openmods.model.ModelUpdater;
import org.apache.commons.lang3.tuple.Pair;

public final class PerspectiveAwareModel
implements IModelCustomData {
    public static final PerspectiveAwareModel EMPTY = new PerspectiveAwareModel((Optional<ResourceLocation>)Optional.absent(), (Map<ItemCameraTransforms.TransformType, ResourceLocation>)ImmutableMap.of());
    private final Optional<ResourceLocation> base;
    private final Map<ItemCameraTransforms.TransformType, ResourceLocation> models;

    public PerspectiveAwareModel(Optional<ResourceLocation> base, Map<ItemCameraTransforms.TransformType, ResourceLocation> models) {
        this.base = base;
        this.models = ImmutableMap.copyOf(models);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.models.values(), (Iterable)this.base.asSet()));
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of();
    }

    private static IBakedModel bakeModel(ResourceLocation model, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel baseModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)model, (String)("Couldn't load MultiLayerModel dependency: " + model));
        return baseModel.bake((IModelState)new ModelStateComposition(state, baseModel.getDefaultState()), format, bakedTextureGetter);
    }

    public IBakedModel bake(final IModelState state, final VertexFormat format, final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        Map bakedModels = Maps.transformValues(this.models, (Function)new Function<ResourceLocation, IBakedModel>(){

            @Nullable
            public IBakedModel apply(@Nullable ResourceLocation location) {
                return PerspectiveAwareModel.bakeModel(location, state, format, (Function<ResourceLocation, TextureAtlasSprite>)bakedTextureGetter);
            }
        });
        IModel missing = ModelLoaderRegistry.getMissingModel();
        IBakedModel bakedMissing = missing.bake(missing.getDefaultState(), format, bakedTextureGetter);
        IBakedModel bakedBase = this.base.isPresent() ? PerspectiveAwareModel.bakeModel((ResourceLocation)this.base.get(), state, format, bakedTextureGetter) : bakedMissing;
        return new PerspectiveAwareBakedModel(bakedModels, bakedBase, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)IPerspectiveAwareModel.MapWrapper.getTransforms((IModelState)state));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public PerspectiveAwareModel process(ImmutableMap<String, String> customData) {
        ModelUpdater updater = new ModelUpdater((Map<String, String>)customData);
        Optional<ResourceLocation> base = updater.get("base", ModelUpdater.MODEL_LOCATION, this.base);
        HashMap models = Maps.newHashMap();
        for (ItemCameraTransforms.TransformType layer : ItemCameraTransforms.TransformType.values()) {
            ResourceLocation result = updater.get(layer.toString(), ModelUpdater.MODEL_LOCATION, this.models.get(layer));
            if (result == null) continue;
            models.put(layer, result);
        }
        return updater.hasChanged() ? new PerspectiveAwareModel(base, models) : this;
    }

    private static final class PerspectiveAwareBakedModel
    extends BakedModelAdapter {
        private final Map<ItemCameraTransforms.TransformType, IBakedModel> models;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms;

        public PerspectiveAwareBakedModel(Map<ItemCameraTransforms.TransformType, IBakedModel> models, IBakedModel base, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            super(base, cameraTransforms);
            this.models = ImmutableMap.copyOf(models);
            this.cameraTransforms = cameraTransforms;
        }

        @Override
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            IBakedModel model = this.models.get(cameraTransformType);
            if (model == null) {
                model = this.base;
            }
            if (model instanceof IPerspectiveAwareModel) {
                return ((IPerspectiveAwareModel)model).handlePerspective(cameraTransformType);
            }
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)model, this.cameraTransforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }
    }
}

