/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class SingleFluidBucketHandler
implements IFluidHandler {
    private final ItemStack filledContainer;
    private final int volume;
    private final ItemStack emptyContainer;
    private final FluidStack contents;
    private final IFluidTankProperties properties;
    private boolean isEmpty;

    public SingleFluidBucketHandler(ItemStack filledContainer, ItemStack emptyContainer, Fluid fluid, final int volume) {
        this.volume = volume;
        this.filledContainer = filledContainer;
        this.emptyContainer = emptyContainer.func_77946_l();
        this.contents = new FluidStack(fluid, volume);
        this.properties = new IFluidTankProperties(){

            public FluidStack getContents() {
                return SingleFluidBucketHandler.this.isEmpty ? null : SingleFluidBucketHandler.this.contents.copy();
            }

            public int getCapacity() {
                return volume;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return SingleFluidBucketHandler.this.contents.isFluidEqual(fluidStack);
            }

            public boolean canDrain() {
                return true;
            }
        };
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.properties};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    protected void switchToEmptyBucket() {
        this.filledContainer.deserializeNBT(this.emptyContainer.serializeNBT());
        this.isEmpty = true;
    }

    private boolean isValidResource(FluidStack resource) {
        return this.contents.isFluidEqual(resource) && resource.amount >= this.volume;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.isEmpty || this.filledContainer.field_77994_a != 1 || !this.isValidResource(resource)) {
            return null;
        }
        if (doDrain) {
            this.switchToEmptyBucket();
        }
        return this.contents.copy();
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.isEmpty || this.filledContainer.field_77994_a != 1 || maxDrain < this.volume) {
            return null;
        }
        if (doDrain) {
            this.switchToEmptyBucket();
        }
        return this.contents.copy();
    }
}

