/*
 * Decompiled with CFR 0.152.
 */
package openmods.liquids;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public abstract class ContainerBucketFillHandler {
    @GameRegistry.ObjectHolder(value="minecraft:bucket")
    public static final Item EMPTY_BUCKET = null;

    protected abstract boolean canFill(World var1, BlockPos var2, TileEntity var3);

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent evt) {
        ItemStack bucketToFill;
        IFluidHandler bucketContainer;
        IFluidHandler source;
        FluidStack fluidInContainer;
        if (evt.getResult() != Event.Result.DEFAULT) {
            return;
        }
        if (evt.getEmptyBucket().func_77973_b() != EMPTY_BUCKET) {
            return;
        }
        RayTraceResult target = evt.getTarget();
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        TileEntity te = evt.getWorld().func_175625_s(target.func_178782_a());
        if (te == null) {
            return;
        }
        if (!this.canFill(evt.getWorld(), target.func_178782_a(), te)) {
            return;
        }
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, target.field_178784_b) && (fluidInContainer = (source = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, target.field_178784_b)).drain(1000, false)) != null && (bucketContainer = FluidUtil.getFluidHandler((ItemStack)(bucketToFill = evt.getEmptyBucket().func_77946_l()))) != null && bucketContainer.fill(fluidInContainer, false) == fluidInContainer.amount) {
            source.drain(fluidInContainer, true);
            bucketContainer.fill(fluidInContainer, true);
            evt.setFilledBucket(bucketToFill);
            evt.setResult(Event.Result.ALLOW);
        }
    }
}

