/*
 * Decompiled with CFR 0.152.
 */
package openmods.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openmods.OpenMods;
import openmods.item.IMetaItem;
import openmods.item.IMetaItemFactory;

public abstract class ItemGeneric
extends Item {
    protected Map<Integer, IMetaItem> metaitems = Maps.newHashMap();

    public ItemGeneric() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public void registerItems(IMetaItemFactory ... factories) {
        for (IMetaItemFactory m : factories) {
            if (!m.isEnabled()) continue;
            this.registerItem(m.getMeta(), m.createMetaItem());
        }
    }

    public void registerItem(int id, IMetaItem item) {
        IMetaItem prev = this.metaitems.put(id, item);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Config error: replacing meta item %s with %s", (Object[])new Object[]{prev, item});
        OpenMods.proxy.registerCustomItemModel(this, id, item.getLocation());
    }

    public void initRecipes() {
        for (IMetaItem item : this.metaitems.values()) {
            item.addRecipe();
        }
    }

    public String func_77667_c(ItemStack stack) {
        IMetaItem meta = this.getMeta(stack.func_77952_i());
        if (meta != null) {
            return "item." + meta.getUnlocalizedName(stack);
        }
        return "";
    }

    public EnumActionResult func_180614_a(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IMetaItem meta = this.getMeta(itemStack.func_77952_i());
        return meta != null ? meta.onItemUse(itemStack, player, world, pos, hand, facing, hitX, hitY, hitZ) : EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        IMetaItem meta = this.getMeta(itemStack.func_77952_i());
        return meta != null ? meta.onItemRightClick(itemStack, world, player, hand) : ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase target, EntityLivingBase player) {
        IMetaItem meta = this.getMeta(itemStack.func_77952_i());
        if (meta != null) {
            return meta.hitEntity(itemStack, target, player);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        IMetaItem meta = this.getMeta(itemStack.func_77952_i());
        return meta != null ? meta.hasEffect() : false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subItems) {
        for (Map.Entry<Integer, IMetaItem> entry : this.metaitems.entrySet()) {
            entry.getValue().addToCreativeList(item, entry.getKey(), subItems);
        }
    }

    public IMetaItem getMeta(int id) {
        return this.metaitems.get(id);
    }

    public IMetaItem getMeta(ItemStack itemStack) {
        return this.getMeta(itemStack.func_77952_i());
    }

    public ItemStack newItemStack(int id) {
        return this.newItemStack(id, 1);
    }

    public ItemStack newItemStack(int id, int number) {
        return new ItemStack((Item)this, number, id);
    }

    public ItemStack newItemStack(IMetaItem meta, int size) {
        for (Map.Entry<Integer, IMetaItem> o : this.metaitems.entrySet()) {
            if (!o.getValue().equals(meta)) continue;
            return this.newItemStack(o.getKey(), size);
        }
        return null;
    }
}

