/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import openmods.api.IValueReceiver;
import openmods.gui.component.GuiComponentResizable;
import openmods.gui.misc.BoxRenderer;
import openmods.utils.MiscUtils;
import org.lwjgl.opengl.GL11;

public class GuiComponentTankLevel
extends GuiComponentResizable {
    private static final BoxRenderer BOX_RENDERER = new BoxRenderer(0, 0);
    private static final int BORDER_COLOR = 0xC6C6C6;
    private FluidStack fluidStack;
    private int capacity;
    private boolean displayFluidName = true;

    public GuiComponentTankLevel(int x, int y, int width, int height, int capacity) {
        super(x, y, width, height);
        this.capacity = capacity;
    }

    private static void addVertexWithUV(double x, double y, double z, float u, float v) {
        GL11.glTexCoord2f((float)u, (float)v);
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    @Override
    public void render(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindComponentsSheet();
        BOX_RENDERER.render(this, this.x + offsetX, this.y + offsetY, this.width, this.height, 0xC6C6C6);
        if (this.fluidStack == null) {
            return;
        }
        Fluid fluid = this.fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        this.parent.bindTexture(TextureMap.field_110575_b);
        ResourceLocation textureLocation = fluid.getStill(this.fluidStack);
        TextureAtlasSprite icon = this.parent.getIcon(textureLocation);
        if (icon != null) {
            double percentFull = Math.max(0.0, Math.min(1.0, (double)this.fluidStack.amount / (double)this.capacity));
            double fluidHeight = (double)(this.height - 3) * percentFull;
            int posX = offsetX + this.x;
            int posY = offsetY + this.y;
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            GL11.glBegin((int)7);
            GuiComponentTankLevel.addVertexWithUV(posX + 3, posY + this.height - 3, this.field_73735_i, minU, maxV);
            GuiComponentTankLevel.addVertexWithUV(posX + this.width - 3, posY + this.height - 3, this.field_73735_i, maxU, maxV);
            GuiComponentTankLevel.addVertexWithUV(posX + this.width - 3, (double)posY + ((double)this.height - fluidHeight), this.field_73735_i, maxU, minV);
            GuiComponentTankLevel.addVertexWithUV(posX + 3, (double)posY + ((double)this.height - fluidHeight), this.field_73735_i, minU, minV);
            GL11.glEnd();
        }
    }

    @Override
    public void renderOverlay(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.fluidStack != null && this.isMouseOver(mouseX, mouseY)) {
            String translatedFluidName;
            ArrayList lines = Lists.newArrayListWithCapacity((int)2);
            if (this.displayFluidName && !Strings.isNullOrEmpty((String)(translatedFluidName = MiscUtils.getTranslatedFluidName(this.fluidStack)))) {
                lines.add(translatedFluidName);
            }
            lines.add(String.format("%d/%d", this.fluidStack.amount, this.capacity));
            this.parent.drawHoveringText(lines, offsetX + mouseX, offsetY + mouseY);
        }
    }

    public void setDisplayFluidNameInTooltip(boolean isEnabled) {
        this.displayFluidName = isEnabled;
    }

    public void setFluid(FluidStack value) {
        this.fluidStack = value;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public IValueReceiver<FluidStack> fluidReceiver() {
        return new IValueReceiver<FluidStack>(){

            @Override
            public void setValue(FluidStack value) {
                GuiComponentTankLevel.this.fluidStack = value;
            }
        };
    }

    public IValueReceiver<Integer> capacityReceiver() {
        return new IValueReceiver<Integer>(){

            @Override
            public void setValue(Integer value) {
                GuiComponentTankLevel.this.capacity = value;
            }
        };
    }
}

