/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;
import openmods.gui.component.GuiComponentTab;
import openmods.gui.listener.IMouseDownListener;

public class GuiComponentTabWrapper
extends BaseComposite {
    protected final BaseComponent mainComponent;
    protected GuiComponentTab activeTab;

    public GuiComponentTabWrapper(int x, int y, BaseComponent mainComponent) {
        super(x, y);
        this.mainComponent = mainComponent;
        this.addComponent(mainComponent);
    }

    @Override
    public BaseComposite addComponent(BaseComponent component) {
        super.addComponent(component);
        if (component instanceof GuiComponentTab) {
            final GuiComponentTab tab = (GuiComponentTab)component;
            component.setX(component.getX() + this.mainComponent.getWidth());
            component.setListener(new IMouseDownListener(){

                @Override
                public void componentMouseDown(BaseComponent component, int x, int y, int button) {
                    if (GuiComponentTabWrapper.this.activeTab != tab) {
                        if (GuiComponentTabWrapper.this.activeTab != null) {
                            GuiComponentTabWrapper.this.activeTab.setActive(false);
                        }
                        GuiComponentTabWrapper.this.activeTab = tab;
                        GuiComponentTabWrapper.this.activeTab.setActive(true);
                    } else if (GuiComponentTabWrapper.this.activeTab != null && GuiComponentTabWrapper.this.activeTab.isOrigin(x, y)) {
                        tab.setActive(false);
                        GuiComponentTabWrapper.this.activeTab = null;
                    }
                }
            });
        }
        return this;
    }

    @Override
    protected void renderComponentBackground(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.realignTabsVertically();
    }

    private int realignTabsVertically() {
        int oY = this.mainComponent.getY() + 4;
        for (BaseComponent component : this.components) {
            if (!(component instanceof GuiComponentTab)) continue;
            component.setY(oY);
            oY += ((GuiComponentTab)component).getHeight() - 1;
        }
        return oY;
    }

    public void onTabClicked(GuiComponentTab tab) {
        if (tab != this.activeTab) {
            if (this.activeTab != null) {
                this.activeTab.setActive(false);
            }
            tab.setActive(true);
            this.activeTab = tab;
        } else {
            tab.setActive(false);
            this.activeTab = null;
        }
    }

    @Override
    public int getWidth() {
        int maxTabWidth = 0;
        for (BaseComponent component : this.components) {
            if (component.getX() + component.getWidth() <= maxTabWidth) continue;
            maxTabWidth = component.getX() + component.getWidth();
        }
        return this.mainComponent.getWidth() + maxTabWidth;
    }

    @Override
    public int getHeight() {
        int maxTabHeight = 0;
        for (BaseComponent component : this.components) {
            if (component.getY() + component.getHeight() <= maxTabHeight) continue;
            maxTabHeight = component.getY() + component.getHeight();
        }
        return this.mainComponent.getHeight() + maxTabHeight;
    }
}

