/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import openmods.gui.Icon;
import openmods.gui.component.GuiComponentSprite;
import openmods.utils.CollectionUtils;

public class GuiComponentCraftingGrid
extends GuiComponentSprite {
    private static final int UPDATE_DELAY = 20;
    private static final Random rnd = new Random();
    private static final Function<ItemStack, ItemStack[]> EXPAND_TRANSFORM = new Function<ItemStack, ItemStack[]>(){

        @Nullable
        public ItemStack[] apply(@Nullable ItemStack input) {
            ItemStack[] itemStackArray;
            if (input != null) {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = input.func_77946_l();
            } else {
                itemStackArray = null;
            }
            return itemStackArray;
        }
    };
    private final ItemStack[][] items;
    private final ItemStack[] selectedItems;
    private int changeCountdown = 20;

    public GuiComponentCraftingGrid(int x, int y, ItemStack[] items, Icon background) {
        this(x, y, CollectionUtils.transform(items, EXPAND_TRANSFORM), background);
    }

    public GuiComponentCraftingGrid(int x, int y, ItemStack[][] items, Icon background) {
        super(x, y, background);
        Preconditions.checkNotNull((Object)items, (Object)"No items in grid");
        this.items = items;
        this.selectedItems = new ItemStack[items.length];
        this.selectItems();
    }

    @Override
    public boolean isTicking() {
        return true;
    }

    @Override
    public void tick() {
        if (this.changeCountdown-- <= 0) {
            this.selectItems();
            this.changeCountdown = 20;
        }
    }

    @Override
    public void render(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.render(offsetX, offsetY, mouseX, mouseY);
        boolean gridOffsetX = true;
        boolean gridOffsetY = true;
        int itemBoxSize = 19;
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack input = this.selectedItems[i];
            if (input == null) continue;
            int row = i % 3;
            int column = i / 3;
            int itemX = offsetX + 1 + row * 19;
            int itemY = offsetY + 1 + column * 19;
            this.drawItemStack(input, this.x + itemX, this.y + itemY, "");
        }
    }

    private void selectItems() {
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack[] slotItems = this.items[i];
            if (slotItems.length == 0) {
                this.selectedItems[i] = null;
                continue;
            }
            int choice = rnd.nextInt(slotItems.length);
            this.selectedItems[i] = slotItems[choice];
        }
    }

    @Override
    public void renderOverlay(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.renderOverlay(offsetX, offsetY, mouseX, mouseY);
        int relativeMouseX = mouseX + offsetX - this.x;
        int relativeMouseY = mouseY + offsetY - this.y;
        boolean gridOffsetX = true;
        boolean gridOffsetY = true;
        int itemBoxSize = 19;
        if (this.isMouseOver(mouseX, mouseY)) {
            ItemStack tooltip = null;
            for (int i = 0; i < this.selectedItems.length; ++i) {
                int row = i % 3;
                int column = i / 3;
                int itemX = offsetX + 1 + row * 19;
                int itemY = offsetY + 1 + column * 19;
                if (relativeMouseX <= itemX - 2 || relativeMouseX >= itemX - 2 + 19 || relativeMouseY <= itemY - 2 || relativeMouseY >= itemY - 2 + 19) continue;
                tooltip = this.selectedItems[i];
                break;
            }
            if (tooltip != null) {
                this.parent.drawItemStackTooltip(tooltip, relativeMouseX + 25, relativeMouseY + 30);
            }
        }
    }
}

