/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import openmods.OpenMods;
import openmods.gui.IComponentParent;
import openmods.gui.Icon;
import openmods.gui.listener.IKeyTypedListener;
import openmods.gui.listener.IMouseDownListener;
import openmods.gui.listener.IMouseDragListener;
import openmods.gui.listener.IMouseUpListener;

public abstract class BaseComponent
extends Gui {
    public static final ResourceLocation WIDGETS = OpenMods.location("textures/gui/components.png");
    protected int x;
    protected int y;
    protected boolean enabled = true;
    private IKeyTypedListener keyListener;
    private IMouseDownListener mouseDownListener;
    private IMouseUpListener mouseUpListener;
    private IMouseDragListener mouseDragListener;
    protected IComponentParent parent;

    protected void bindComponentsSheet() {
        this.parent.bindTexture(WIDGETS);
    }

    public BaseComponent(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void init(IComponentParent parent) {
        this.parent = parent;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + this.getWidth() && mouseY >= this.y && mouseY < this.y + this.getHeight();
    }

    public void setListener(IKeyTypedListener keyListener) {
        this.keyListener = keyListener;
    }

    public void setListener(IMouseDownListener mouseDownListener) {
        this.mouseDownListener = mouseDownListener;
    }

    public void setListener(IMouseUpListener mouseUpListener) {
        this.mouseUpListener = mouseUpListener;
    }

    public void setListener(IMouseDragListener mouseDragListener) {
        this.mouseDragListener = mouseDragListener;
    }

    public void render(int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    public void renderOverlay(int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    public void keyTyped(char keyChar, int keyCode) {
        if (this.keyListener != null) {
            this.keyListener.componentKeyTyped(this, keyChar, keyCode);
        }
    }

    public void mouseDown(int mouseX, int mouseY, int button) {
        if (this.mouseDownListener != null) {
            this.mouseDownListener.componentMouseDown(this, mouseX, mouseY, button);
        }
    }

    public void mouseUp(int mouseX, int mouseY, int button) {
        if (this.mouseUpListener != null) {
            this.mouseUpListener.componentMouseUp(this, mouseX, mouseY, button);
        }
    }

    public void mouseDrag(int mouseX, int mouseY, int button, long time) {
        if (this.mouseDragListener != null) {
            this.mouseDragListener.componentMouseDrag(this, mouseX, mouseY, button, time);
        }
    }

    public boolean isTicking() {
        return false;
    }

    public void tick() {
    }

    protected void drawItemStack(ItemStack stack, int x, int y, String overlayText) {
        RenderHelper.func_74520_c();
        RenderItem itemRenderer = this.parent.getItemRenderer();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        itemRenderer.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.parent.getFontRenderer();
        }
        itemRenderer.func_180450_b(stack, x, y);
        itemRenderer.func_180453_a(font, stack, x, y, overlayText);
        this.field_73735_i = 0.0f;
        itemRenderer.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
    }

    protected void drawItemStack(ItemStack stack, int x, int y) {
        RenderHelper.func_74520_c();
        RenderItem itemRenderer = this.parent.getItemRenderer();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        itemRenderer.field_77023_b = 200.0f;
        itemRenderer.func_180450_b(stack, x, y);
        this.field_73735_i = 0.0f;
        itemRenderer.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
    }

    protected void drawSprite(Icon icon, int x, int y, int width, int height) {
        this.parent.bindTexture(icon.texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)icon.minU, (double)icon.maxV).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)icon.maxU, (double)icon.maxV).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)icon.maxU, (double)icon.minV).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)icon.minU, (double)icon.minV).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void drawSprite(Icon icon, int x, int y) {
        this.drawSprite(icon, x, y, icon.width, icon.height);
    }

    protected void drawHoveringText(List<String> textLines, int x, int y) {
        this.parent.drawHoveringText(textLines, x, y);
    }

    protected void drawHoveringText(String line, int x, int y) {
        this.parent.drawHoveringText((List<String>)ImmutableList.of((Object)line), x, y);
    }
}

